/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.energy.battery;

import com.gendeathrow.hatchery.block.TilePowered;
import com.gendeathrow.hatchery.storage.Connection;
import com.gendeathrow.hatchery.storage.ISidedInterface;
import com.gendeathrow.hatchery.storage.SidedInterface;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BaseBatteryTileEntity
extends TilePowered
implements ITickable,
ISidedInterface {
    public static ArrayList<Connection> ExtensionCables = new ArrayList();
    boolean isCreative = false;
    protected SidedInterface sideInterface = new SidedInterface(SidedInterface.InterfaceOption.PowerInput, SidedInterface.InterfaceOption.PowerOutput);

    public BaseBatteryTileEntity() {
        super(1);
        this.energyStorage.setCapacity(400000).setMaxTransfer(4096);
        this.sideInterface.setInterfaceOnFacing(SidedInterface.InterfaceOption.PowerInput, EnumFacing.field_82609_l);
    }

    @Override
    public SidedInterface getInterface() {
        return this.sideInterface;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.energyStorage.readFromNBT(nbt);
        this.sideInterface.readFromNBT(nbt);
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = this.energyStorage.writeToNBT(nbt);
        this.sideInterface.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    public void func_73660_a() {
        this.transferEnergy();
    }

    protected void transferEnergy() {
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity reciever;
            if (this.getEnergyStorage().getEnergyStored() <= 0 || this.sideInterface.getInterfaceOnFacing(facing, SidedInterface.InterfaceType.Power) != SidedInterface.InterfaceOption.PowerOutput || (reciever = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !reciever.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) continue;
            IEnergyStorage enegeryReveiever = (IEnergyStorage)reciever.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d());
            if (this.isCreative) {
                enegeryReveiever.receiveEnergy(this.energyStorage.getMaxExtract(), false);
                continue;
            }
            int extraction = this.extractEnergy(facing, this.energyStorage.getMaxExtract(), true);
            int leftover = enegeryReveiever.receiveEnergy(extraction, false);
            this.extractEnergy(facing, leftover, false);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.sideInterface.getInterfaceOnFacing(from, SidedInterface.InterfaceType.Power) == SidedInterface.InterfaceOption.PowerInput) {
            return this.energyStorage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.sideInterface.getInterfaceOnFacing(from, SidedInterface.InterfaceType.Power) == SidedInterface.InterfaceOption.PowerOutput) {
            return this.energyStorage.extractEnergy(maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored() > 0;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return BaseBatteryTileEntity.this.receiveEnergy(from, maxReceive, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return BaseBatteryTileEntity.this.extractEnergy(from, maxExtract, simulate);
                }

                public int getEnergyStored() {
                    return BaseBatteryTileEntity.this.getEnergyStored(from);
                }

                public int getMaxEnergyStored() {
                    return BaseBatteryTileEntity.this.getMaxEnergyStored(from);
                }

                public boolean canExtract() {
                    return true;
                }

                public boolean canReceive() {
                    return true;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

