/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.fertilizermixer;

import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModFluids;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.item.upgrades.BaseUpgrade;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerFluidMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class FertilizerMixerTileEntity
extends TileUpgradable
implements ITickable {
    int baseTankSize = 12000;
    int baseRFStorage = 20000;
    int baseRFTick = 20;
    double rfEffencyMultpyler = 1.0;
    double upgradeSpeedMulipyler = 1.0;
    private FluidTank waterTank = new FluidTank(new FluidStack(FluidRegistry.WATER, 0), 12000){

        public boolean canDrain() {
            return false;
        }
    };
    private FluidTank fertilizerTank = new FluidTank(new FluidStack(ModFluids.liquidfertilizer, 0), 12000){

        public boolean canFill() {
            return false;
        }
    };
    private FluidHandlerFluidMap fluidMap = new FluidHandlerFluidMap().addHandler(ModFluids.liquidfertilizer, (IFluidHandler)this.fertilizerTank).addHandler(FluidRegistry.WATER, (IFluidHandler)this.waterTank);
    protected InventoryStroageModifiable inputInventory = new InventoryStroageModifiable("inputItems", 3){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            if (slot == 0 && (stack.func_77973_b() == ModItems.manure || stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.manureBlock))) {
                return true;
            }
            return slot == 1 && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) ? FluidUtil.getFluidContained((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack).getFluid() == FluidRegistry.WATER : slot == 2 && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (FluidUtil.getFluidContained((ItemStack)stack) == null || FluidUtil.getFluidContained((ItemStack)stack).getFluid() == ModFluids.liquidfertilizer);
        }
    };
    protected InventoryStroageModifiable outputInventory = new InventoryStroageModifiable("outputItems", 2){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return false;
        }
    };
    protected EnergyStorageRF energy = new EnergyStorageRF(20000).setMaxReceive(100);
    private int fertlizerMixTime;
    private int currentItemMixTime;
    private int mixTime;
    private int totalMixTime;
    private int calcMixTick = 1;
    public int waterLevel = 0;
    public int fertilizerLevel = 0;
    public int storedEnergyLevel = 0;

    public FertilizerMixerTileEntity() {
        super(2);
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public FluidTank getFertilizerTank() {
        return this.fertilizerTank;
    }

    public boolean isMixing() {
        return this.fertlizerMixTime > 0 && !this.field_145850_b.func_175640_z(this.func_174877_v());
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isMixing(IInventory inventory) {
        return inventory.func_174887_a_(2) > 0;
    }

    public boolean canMix() {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return false;
        }
        return this.waterTank.getFluidAmount() > 0 && this.fertilizerTank.getFluidAmount() < this.fertilizerTank.getCapacity();
    }

    public static int getItemMixTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == ModItems.manure) {
            return 100;
        }
        if (item == Item.func_150898_a((Block)ModBlocks.manureBlock)) {
            return 1120;
        }
        return 0;
    }

    private ItemStack getManureInSlot() {
        return this.inputInventory.getStackInSlot(0);
    }

    private ItemStack getWaterInSlot() {
        return this.inputInventory.getStackInSlot(1);
    }

    private ItemStack getBucketOutWaterSlot() {
        return this.outputInventory.getStackInSlot(0);
    }

    private ItemStack getBucketInFertilizerrSlot() {
        return this.inputInventory.getStackInSlot(2);
    }

    private ItemStack getBucketOutFertilizerSlot() {
        return this.outputInventory.getStackInSlot(1);
    }

    public void func_73660_a() {
        boolean flag = this.isMixing();
        boolean flag1 = false;
        if (this.isMixing() && this.canMix() && (this.fertlizerMixTime -= this.calcMixTick) < 0) {
            this.fertlizerMixTime = 0;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            IFluidHandlerItem handler;
            ItemStack newStack;
            this.updateUpgrades();
            if (this.isMixing() || this.getManureInSlot() != null) {
                if (!this.isMixing() && this.canMix()) {
                    this.currentItemMixTime = this.fertlizerMixTime = FertilizerMixerTileEntity.getItemMixTime(this.getManureInSlot());
                    if (this.isMixing()) {
                        flag1 = true;
                        if (this.getManureInSlot() != null) {
                            this.getManureInSlot().func_190918_g(1);
                            if (this.getManureInSlot().func_190916_E() <= 0) {
                                this.inputInventory.setStackInSlot(0, ItemStack.field_190927_a);
                            }
                        }
                    }
                }
                int rfNeeded = (int)(10.0 * this.upgradeSpeedMulipyler * this.rfEffencyMultpyler);
                if (this.isMixing() && this.canMix() && this.fertlizerMixTime >= 5 && this.energy.getEnergyStored() >= rfNeeded) {
                    this.calcMixTick = (int)(5.0 * this.upgradeSpeedMulipyler);
                    this.energy.extractEnergy(rfNeeded, false);
                    this.fertilizerTank.fillInternal(new FluidStack(ModFluids.liquidfertilizer, (int)(5.0 * this.upgradeSpeedMulipyler)), true);
                    this.waterTank.drainInternal((int)(5.0 * this.upgradeSpeedMulipyler), true);
                    flag1 = true;
                } else if (this.isMixing() && this.canMix() && this.fertlizerMixTime >= 1) {
                    this.calcMixTick = 1;
                    this.fertilizerTank.fillInternal(new FluidStack(ModFluids.liquidfertilizer, 1), true);
                    this.waterTank.drainInternal(1, true);
                    flag1 = true;
                } else {
                    this.mixTime = 0;
                }
            } else if (!this.isMixing() && this.mixTime > 0) {
                this.mixTime = MathHelper.func_76125_a((int)(this.mixTime - 2), (int)0, (int)this.totalMixTime);
            }
            if (!this.getWaterInSlot().func_190926_b() && this.waterTank.getFluidAmount() < this.waterTank.getCapacity()) {
                ItemStack stack = this.getWaterInSlot();
                newStack = this.getWaterInSlot().func_77946_l();
                newStack.func_190920_e(1);
                handler = FluidUtil.getFluidHandler((ItemStack)newStack);
                if (handler != null && this.getBucketOutWaterSlot().func_190926_b() && FluidUtil.tryFluidTransfer((IFluidHandler)this.waterTank, (IFluidHandler)handler, (int)this.waterTank.getCapacity(), (boolean)true) != null) {
                    if (newStack.func_190916_E() > 0) {
                        this.outputInventory.setStackInSlot(0, handler.getContainer());
                    }
                    this.inputInventory.extractItem(1, 1, false);
                }
            }
            if (!this.getBucketInFertilizerrSlot().func_190926_b() && this.getBucketOutFertilizerSlot().func_190926_b() && this.fertilizerTank.getFluidAmount() > 0) {
                ItemStack oldStack = this.getBucketInFertilizerrSlot();
                newStack = this.getBucketInFertilizerrSlot().func_77946_l();
                if (newStack.func_190916_E() > 1) {
                    newStack.func_190920_e(1);
                }
                if ((handler = FluidUtil.getFluidHandler((ItemStack)newStack)) != null && FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this.fertilizerTank, (int)this.fertilizerTank.getCapacity(), (boolean)true) != null) {
                    this.outputInventory.setStackInSlot(1, handler.getContainer());
                    if (oldStack.func_190916_E() > 1) {
                        this.inputInventory.extractItem(2, 1, false);
                    } else {
                        this.inputInventory.setStackInSlot(2, ItemStack.field_190927_a);
                    }
                }
            }
        }
        if (flag != this.isMixing()) {
            flag1 = true;
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean canUseUpgrade(ItemStack item) {
        return item.func_77973_b() == ModItems.rfUpgradeTier || item.func_77973_b() == ModItems.speedUpgradeTier || item.func_77973_b() == ModItems.tankUpgradeTier1 || item.func_77973_b() == ModItems.rfCapacityUpgradeTier1;
    }

    protected void updateUpgrades() {
        boolean rfupgrade = false;
        boolean rfcapacity = false;
        boolean tankcapacity = false;
        boolean speedupgrade = false;
        for (ItemStack upgrade : this.getAllUpgrades()) {
            int tier;
            if (upgrade.func_190926_b()) continue;
            if (upgrade.func_77973_b() == ModItems.rfUpgradeTier) {
                rfupgrade = true;
                this.rfEffencyMultpyler = 1.0 - (double)((BaseUpgrade)upgrade.func_77973_b()).getUpgradeTier(upgrade, "") * 0.1;
            }
            if (upgrade.func_77973_b() == ModItems.speedUpgradeTier && !speedupgrade) {
                speedupgrade = true;
                this.upgradeSpeedMulipyler = 1 + ((BaseUpgrade)upgrade.func_77973_b()).getUpgradeTier(upgrade, "") * 1;
            }
            if (upgrade.func_77973_b() == ModItems.tankUpgradeTier1 && !tankcapacity) {
                tankcapacity = true;
                tier = upgrade.func_77960_j() + 1;
                int newTank = this.baseTankSize;
                if (tier == 1) {
                    newTank += 2000;
                } else if (tier == 2) {
                    newTank += 4000;
                } else if (tier == 3) {
                    newTank += 6000;
                }
                if (newTank != this.fertilizerTank.getCapacity()) {
                    this.fertilizerTank.setCapacity(newTank);
                }
                if (newTank != this.waterTank.getCapacity()) {
                    this.waterTank.setCapacity(newTank);
                }
            }
            if (upgrade.func_77973_b() != ModItems.rfCapacityUpgradeTier1 || rfcapacity) continue;
            tier = upgrade.func_77960_j() + 1;
            int newEnergy = this.baseRFStorage;
            rfcapacity = true;
            if (tier == 1) {
                newEnergy += (int)((double)newEnergy * 0.5);
            } else if (tier == 2) {
                newEnergy += (int)((double)newEnergy * 0.75);
            } else if (tier == 3) {
                newEnergy += newEnergy * 1;
            }
            if (newEnergy == this.energy.getMaxEnergyStored()) continue;
            this.energy.setCapacity(newEnergy);
        }
        if (!tankcapacity && this.fertilizerTank.getCapacity() != this.baseTankSize) {
            this.fertilizerTank.setCapacity(this.baseTankSize);
        }
        if (!tankcapacity && this.waterTank.getCapacity() != this.baseTankSize) {
            this.waterTank.setCapacity(this.baseTankSize);
        }
        if (!rfcapacity && this.energy.getMaxEnergyStored() != this.baseRFStorage) {
            this.energy.setCapacity(this.baseRFStorage);
        }
        if (!rfupgrade && this.rfEffencyMultpyler != 1.0) {
            this.rfEffencyMultpyler = 1.0;
        }
        if (!speedupgrade && this.upgradeSpeedMulipyler != 1.0) {
            this.upgradeSpeedMulipyler = 1.0;
        }
    }

    public int getMixTime(@Nullable ItemStack stack) {
        return 200;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.waterTank.getFluidAmount();
            }
            case 1: {
                return this.fertilizerTank.getFluidAmount();
            }
            case 2: {
                return this.fertlizerMixTime;
            }
            case 3: {
                return this.energy.getEnergyStored();
            }
            case 4: {
                return this.waterTank.getCapacity();
            }
            case 5: {
                return this.fertilizerTank.getCapacity();
            }
            case 6: {
                return this.energy.getMaxEnergyStored();
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.waterLevel = value;
                break;
            }
            case 1: {
                this.fertilizerLevel = value;
                break;
            }
            case 2: {
                this.fertlizerMixTime = value;
                break;
            }
            case 3: {
                this.energy.setEnergyStored(value);
                break;
            }
            case 4: {
                this.waterTank.setCapacity(value);
                break;
            }
            case 5: {
                this.fertilizerTank.setCapacity(value);
                break;
            }
            case 6: {
                this.energy.setCapacity(value);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.waterTank.readFromNBT(tag.func_74775_l("waterTank"));
        this.fertilizerTank.readFromNBT(tag.func_74775_l("fertilizerTank"));
        this.energy.readFromNBT(tag);
        this.inputInventory.readFromNBT(tag);
        this.outputInventory.readFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTTagCompound waterTTag = new NBTTagCompound();
        NBTTagCompound fertTTag = new NBTTagCompound();
        this.waterTank.writeToNBT(waterTTag);
        this.fertilizerTank.writeToNBT(fertTTag);
        tag.func_74782_a("waterTank", (NBTBase)waterTTag);
        tag.func_74782_a("fertilizerTank", (NBTBase)fertTTag);
        this.inputInventory.writeToNBT(tag);
        this.outputInventory.writeToNBT(tag);
        this.energy.writeToNBT(tag);
        return tag;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidMap;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)((Object)this.outputInventory);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inputInventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }
}

