/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.generator;

import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.block.generator.DigesterGeneratorBlock;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModFluids;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;

public class DigesterGeneratorTileEntity
extends TileUpgradable
implements ITickable {
    public int time = 0;
    protected int baseEnergyStorage = 200000;
    protected int baseTankStorage = 5000;
    protected EnergyStorageRF energy = new EnergyStorageRF(200000){

        @Override
        public boolean canReceive() {
            return false;
        }
    };
    protected InventoryStroageModifiable inputInventory = new InventoryStroageModifiable("inputItems", 2){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return slot == 0 && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && FluidUtil.getFluidContained((ItemStack)stack) != null && FluidUtil.getFluidContained((ItemStack)stack).getFluid() == ModFluids.liquidfertilizer;
        }
    };
    protected InventoryStroageModifiable outputInventory = new InventoryStroageModifiable("outputItems", 2);
    private int rfPerTick = 20;
    private int baseRfPerTick = 20;
    boolean isGenerating;
    private FluidTank fertlizerTank = new FluidTank(new FluidStack(ModFluids.liquidfertilizer, 0), 5000){

        public boolean canDrain() {
            return false;
        }
    };
    int rfEnergyFuel = 15000;
    int fuelRF;
    boolean isActive = true;
    public boolean updateState = false;
    public float tankLevel;

    public DigesterGeneratorTileEntity() {
        super(2);
    }

    public FluidTank getFertilizerTank() {
        return this.fertlizerTank;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() == ModBlocks.digesterGenerator && newSate.func_177230_c() == ModBlocks.digesterGenerator) {
            return false;
        }
        return oldState != newSate;
    }

    protected boolean canGenerate() {
        if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
            return false;
        }
        return this.fuelRF > 0 ? true : this.getTank().getFluidAmount() >= 50;
    }

    public boolean isGenerating() {
        if (this.field_145850_b.func_175640_z(this.func_174877_v())) {
            return false;
        }
        return this.fuelRF > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isGenerating();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            IFluidHandlerItem handler;
            this.updateUpgrades();
            if (this.isActive && this.canGenerate() && this.energy.getEnergyStored() < this.energy.getMaxEnergyStored()) {
                if (this.fuelRF <= 0) {
                    this.fuelRF = this.rfEnergyFuel;
                    this.getTank().drainInternal(50, true);
                }
                this.energy.modifyEnergyStored(this.getRFPerTick());
                this.fuelRF -= this.getRFPerTick();
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IEnergyStorage tileEnergy;
                if (this.energy.getEnergyStored() <= 0) break;
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || !(tileEnergy = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).canReceive()) continue;
                int received = tileEnergy.receiveEnergy(this.energy.getEnergyStored(), false);
                this.energy.extractEnergy(received, false);
            }
            if (!this.inputInventory.getStackInSlot(0).func_190926_b() && this.outputInventory.getStackInSlot(0).func_190926_b() && this.fertlizerTank.getFluidAmount() < this.fertlizerTank.getCapacity() && (handler = FluidUtil.getFluidHandler((ItemStack)(stack = this.inputInventory.getStackInSlot(0)))) != null && FluidUtil.tryFluidTransfer((IFluidHandler)this.fertlizerTank, (IFluidHandler)handler, (int)this.fertlizerTank.getCapacity(), (boolean)true) != null) {
                this.outputInventory.setStackInSlot(0, handler.getContainer());
                this.inputInventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (flag != this.isGenerating() || this.updateState) {
                DigesterGeneratorBlock.setState(this.isGenerating(), this.field_145850_b, this.field_174879_c);
                this.updateState = false;
                this.func_70296_d();
            }
        }
    }

    public FluidTank getTank() {
        return this.fertlizerTank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.inputInventory.readFromNBT(nbt);
        this.outputInventory.readFromNBT(nbt);
        this.energy.readFromNBT(nbt);
        this.fertlizerTank.readFromNBT(nbt);
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = this.inputInventory.writeToNBT(nbt);
        nbt = this.outputInventory.writeToNBT(nbt);
        nbt = this.energy.writeToNBT(nbt);
        nbt = this.fertlizerTank.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fertlizerTank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)((Object)this.outputInventory);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inputInventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.energy.getEnergyStored();
            }
            case 1: {
                return this.getTank().getFluidAmount();
            }
            case 2: {
                return this.rfPerTick;
            }
            case 3: {
                return this.energy.getMaxEnergyStored();
            }
            case 4: {
                return this.getTank().getCapacity();
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.energy.setEnergyStored(value);
                break;
            }
            case 1: {
                this.tankLevel = value;
                break;
            }
            case 2: {
                this.rfPerTick = value;
                break;
            }
            case 3: {
                this.energy.setCapacity(value);
                break;
            }
            case 4: {
                this.getTank().setCapacity(value);
                break;
            }
        }
    }

    public int getRFPerTick() {
        return this.rfPerTick;
    }

    @Override
    public boolean canUseUpgrade(ItemStack item) {
        return item.func_77973_b() == ModItems.rfUpgradeTier || item.func_77973_b() == ModItems.tankUpgradeTier1 || item.func_77973_b() == ModItems.rfCapacityUpgradeTier1;
    }

    protected void updateUpgrades() {
        boolean rfupgrade = false;
        boolean rfcapacity = false;
        boolean tankcapacity = false;
        for (ItemStack upgrade : this.getAllUpgrades()) {
            int tier;
            if (upgrade.func_190926_b()) continue;
            if (upgrade.func_77973_b() == ModItems.rfUpgradeTier) {
                rfupgrade = true;
                tier = upgrade.func_77960_j() + 1;
                int newTick = tier * 20 + 20;
                if (newTick > this.getRFPerTick()) {
                    this.rfPerTick = newTick;
                }
            }
            if (upgrade.func_77973_b() == ModItems.tankUpgradeTier1 && !tankcapacity) {
                tankcapacity = true;
                tier = upgrade.func_77960_j() + 1;
                int newTank = this.baseTankStorage;
                if (tier == 1) {
                    newTank += 2000;
                } else if (tier == 2) {
                    newTank += 4000;
                } else if (tier == 3) {
                    newTank += 6000;
                }
                if (newTank != this.fertlizerTank.getCapacity()) {
                    this.fertlizerTank.setCapacity(newTank);
                }
            }
            if (upgrade.func_77973_b() != ModItems.rfCapacityUpgradeTier1 || rfcapacity) continue;
            tier = upgrade.func_77960_j() + 1;
            int newEnergy = this.baseEnergyStorage;
            rfcapacity = true;
            if (tier == 1) {
                newEnergy += (int)((double)newEnergy * 0.5);
            } else if (tier == 2) {
                newEnergy += (int)((double)newEnergy * 0.75);
            } else if (tier == 3) {
                newEnergy += newEnergy * 1;
            }
            if (newEnergy == this.energy.getMaxEnergyStored()) continue;
            this.energy.setCapacity(newEnergy);
        }
        if (!tankcapacity && this.fertlizerTank.getCapacity() != this.baseTankStorage) {
            this.fertlizerTank.setCapacity(this.baseTankStorage);
        }
        if (!rfcapacity && this.energy.getMaxEnergyStored() != this.baseEnergyStorage) {
            this.energy.setCapacity(this.baseEnergyStorage);
        }
        if (!rfupgrade) {
            this.rfPerTick = this.baseRfPerTick;
        }
    }
}

