/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.shredder;

import com.gendeathrow.hatchery.api.crafting.ShredderRecipe;
import com.gendeathrow.hatchery.api.tileentities.IContainerUpdate;
import com.gendeathrow.hatchery.block.TileUpgradable;
import com.gendeathrow.hatchery.block.shredder.ShredderBlock;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.item.upgrades.BaseUpgrade;
import com.gendeathrow.hatchery.storage.EnergyStorageRF;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class ShredderTileEntity
extends TileUpgradable
implements ITickable,
IContainerUpdate {
    public static ArrayList<ShredderRecipe> shredderRecipes = new ArrayList();
    public EnergyStorageRF energy = new EnergyStorageRF(100000).setMaxReceive(100);
    public int animationTicks;
    public int prevAnimationTicks;
    int baseRFStorage = 100000;
    double rfEffencyMultpyler = 1.0;
    double upgradeSpeedMulipyler = 1.0;
    protected InventoryStroageModifiable inputInventory = new InventoryStroageModifiable("inputItems", 1){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return ShredderTileEntity.isShreddableItem(stack);
        }
    };
    protected InventoryStroageModifiable outputInventory = new InventoryStroageModifiable("outputItems", 2){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return false;
        }
    };
    private int transferCooldown = -1;
    int slotIn = 0;
    private int shreddingTime;
    private int currentItemShreddingTime;
    private int shredTime;
    private int totalshredTime;
    private int rfTick = 20;
    private ItemStack shreddedItem;

    public ShredderTileEntity() {
        super(2);
    }

    public static void registerShredderRecipes() {
        ShredderTileEntity.addRecipe(new ItemStack(Items.field_151008_G), new ItemStack(ModItems.featherFiber), new ItemStack(ModItems.featherMeal));
        ShredderTileEntity.addRecipe(new ItemStack(ModItems.featherFiber), new ItemStack(ModItems.featherMeal));
        ShredderTileEntity.addRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.WHITE.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150327_N, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.YELLOW.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.LIGHT_BLUE.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.MAGENTA.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.SILVER.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.ORANGE.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.SILVER.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.PINK.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b()), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.SILVER.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.YELLOW.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.MAGENTA.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.RED.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.PINK.func_176767_b()));
        ShredderTileEntity.addRecipe(new ItemStack(Items.field_185164_cV, 1), new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()));
    }

    private static void addRecipe(ItemStack input, ItemStack output) {
        ShredderTileEntity.addRecipe(input, output, ItemStack.field_190927_a);
    }

    private static void addRecipe(ItemStack input, ItemStack output, ItemStack extra) {
        shredderRecipes.add(new ShredderRecipe(input, output, extra));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && ShredderBlock.isActive(this.field_145850_b.func_180495_p(this.field_174879_c))) {
            this.prevAnimationTicks = this.animationTicks;
            if (this.animationTicks < 360) {
                this.animationTicks += 5;
            }
            if (this.animationTicks >= 360) {
                this.animationTicks -= 360;
                this.prevAnimationTicks -= 360;
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.updateUpgrades();
            boolean flag = this.isShredding();
            boolean flag1 = false;
            --this.transferCooldown;
            if (!this.isOnTransferCooldown()) {
                this.captureDroppedItems();
                this.setTransferCooldown(8);
            }
            if (!this.isShredding() && this.canShred() && this.hasPower()) {
                this.currentItemShreddingTime = this.shreddingTime = this.setShredTime(this.inputInventory.getStackInSlot(0));
                if (this.isShredding()) {
                    this.shreddedItem = this.inputInventory.extractItemInternal(0, 1, false);
                }
            }
            if (this.isShredding() && this.hasPower()) {
                this.shreddingTime = (int)((double)this.shreddingTime - 1.0 * this.upgradeSpeedMulipyler);
                this.energy.extractEnergy((int)((double)this.rfTick * this.upgradeSpeedMulipyler * this.rfEffencyMultpyler), false);
                if (this.shreddingTime <= 0) {
                    this.shredItem();
                }
            }
            if (flag != (this.isShredding() && this.hasPower())) {
                flag1 = true;
                ShredderBlock.setActive(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.isShredding() && this.hasPower());
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public boolean canUseUpgrade(ItemStack item) {
        return item.func_77973_b() == ModItems.rfCapacityUpgradeTier1 || item.func_77973_b() == ModItems.speedUpgradeTier || item.func_77973_b() == ModItems.rfUpgradeTier;
    }

    protected void updateUpgrades() {
        boolean rfupgrade = false;
        boolean rfcapacity = false;
        boolean speedupgrade = false;
        for (ItemStack upgrade : this.getAllUpgrades()) {
            if (upgrade.func_190926_b()) continue;
            if (upgrade.func_77973_b() == ModItems.rfUpgradeTier) {
                rfupgrade = true;
                this.rfEffencyMultpyler = 1.0 - (double)((BaseUpgrade)upgrade.func_77973_b()).getUpgradeTier(upgrade, "") * 0.1;
            }
            if (upgrade.func_77973_b() == ModItems.speedUpgradeTier && !speedupgrade) {
                speedupgrade = true;
                this.upgradeSpeedMulipyler = 1 + ((BaseUpgrade)upgrade.func_77973_b()).getUpgradeTier(upgrade, "") * 1;
            }
            if (upgrade.func_77973_b() != ModItems.rfCapacityUpgradeTier1 || rfcapacity) continue;
            int tier = upgrade.func_77960_j() + 1;
            int newEnergy = this.baseRFStorage;
            rfcapacity = true;
            if (tier == 1) {
                newEnergy += (int)((double)newEnergy * 0.5);
            } else if (tier == 2) {
                newEnergy += (int)((double)newEnergy * 0.75);
            } else if (tier == 3) {
                newEnergy += newEnergy * 1;
            }
            if (newEnergy == this.energy.getMaxEnergyStored()) continue;
            this.energy.setCapacity(newEnergy);
        }
        if (!rfcapacity && this.energy.getMaxEnergyStored() != this.baseRFStorage) {
            this.energy.setCapacity(this.baseRFStorage);
        }
        if (!rfupgrade && this.rfEffencyMultpyler != 1.0) {
            this.rfEffencyMultpyler = 1.0;
        }
        if (!speedupgrade && this.upgradeSpeedMulipyler != 1.0) {
            this.upgradeSpeedMulipyler = 1.0;
        }
    }

    public int getShreddingTime() {
        return this.shreddingTime;
    }

    public int getTotalShredTime() {
        return this.shredTime;
    }

    public int setShredTime(ItemStack stack) {
        this.shredTime = this.getRecipe((ItemStack)stack).shredTime;
        return this.shredTime;
    }

    public void shredItem() {
        ShredderRecipe recipe;
        ItemStack stack = this.inputInventory.getStackInSlot(0);
        boolean flag = false;
        if (this.shreddedItem != null && ShredderTileEntity.isShreddableItem(this.shreddedItem) && (recipe = this.getRecipe(this.shreddedItem)) != null && recipe.hasOutput()) {
            ItemStack extra;
            this.outputInventory.insertItemInternal(0, recipe.getOutputItem(), false);
            if (!recipe.getExtraItemByChance().func_190926_b() && (extra = recipe.getExtraItemByChance()) != null) {
                this.outputInventory.insertItemInternal(1, extra, false);
            }
            flag = true;
        }
    }

    private boolean canShred() {
        if (this.inputInventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ShredderRecipe recipe = this.getRecipe(this.inputInventory.getStackInSlot(0));
        if (recipe == null) {
            return false;
        }
        ItemStack itemstack = recipe.itemOut;
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (this.outputInventory.getStackInSlot(0).func_190926_b()) {
            return true;
        }
        if (!this.outputInventory.getStackInSlot(0).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.outputInventory.getStackInSlot(0).func_190916_E() + itemstack.func_190916_E();
        return result <= 64 && result <= this.outputInventory.getStackInSlot(0).func_77976_d();
    }

    public boolean isShredding() {
        return this.shreddingTime > 0;
    }

    public boolean hasPower() {
        return !this.field_145850_b.func_175640_z(this.field_174879_c) && (double)this.energy.getEnergyStored() >= (double)this.rfTick * this.upgradeSpeedMulipyler * this.rfEffencyMultpyler;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShredding(IInventory inventory) {
        return inventory.func_174887_a_(1) > 0;
    }

    protected ShredderRecipe getRecipe(ItemStack stack) {
        for (ShredderRecipe recipe : shredderRecipes) {
            if (!recipe.isInputItem(stack)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isShreddableItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ShredderRecipe recipe : shredderRecipes) {
            if (!recipe.isInputItem(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void setTransferCooldown(int cooldown) {
        this.transferCooldown = cooldown;
    }

    public boolean captureDroppedItems() {
        EnumFacing enumfacing = EnumFacing.DOWN;
        boolean flag = false;
        for (EntityItem entityitem : ShredderTileEntity.getCaptureItems(this.field_145850_b, this.getXPos(), this.getYPos(), this.getZPos())) {
            if (!ShredderTileEntity.isShreddableItem(entityitem.func_92059_d())) continue;
            ItemStack itemstack = entityitem.func_92059_d().func_77946_l();
            ItemStack itemstack1 = this.inputInventory.insertItemInternal(0, itemstack, false);
            if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() != 0) {
                entityitem.func_92059_d().func_190920_e(itemstack1.func_190916_E());
            } else {
                flag = true;
                entityitem.func_70106_y();
            }
            return flag;
        }
        return flag;
    }

    public static List<EntityItem> getCaptureItems(World worldIn, double x, double y, double z) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB(x - 0.5, y, z - 0.5, x + 0.5, y + 1.5, z + 0.5), EntitySelectors.field_94557_a);
    }

    public double getXPos() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double getYPos() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double getZPos() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.energy.getEnergyStored();
            }
            case 1: {
                return this.shreddingTime;
            }
            case 2: {
                return this.currentItemShreddingTime;
            }
            case 3: {
                return this.energy.getMaxEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.energy.setEnergyStored(value);
                break;
            }
            case 1: {
                this.shreddingTime = value;
                break;
            }
            case 2: {
                this.currentItemShreddingTime = value;
                break;
            }
            case 3: {
                this.energy.setCapacity(value);
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        this.outputInventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.inputInventory.deserializeNBT(tag.func_74775_l("inputinventory"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.outputInventory.serializeNBT());
        tag.func_74782_a("inputinventory", (NBTBase)this.inputInventory.serializeNBT());
        this.energy.writeToNBT(tag);
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() == ModBlocks.shredder && newSate.func_177230_c() == ModBlocks.shredder) {
            return false;
        }
        return oldState != newSate;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)((Object)this.outputInventory);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inputInventory);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energy;
        }
        return (T)super.getCapability(capability, facing);
    }
}

