/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.core.jei;

import com.gendeathrow.hatchery.api.crafting.NestingPenDropRecipe;
import com.gendeathrow.hatchery.api.crafting.ShredderRecipe;
import com.gendeathrow.hatchery.block.shredder.ShredderTileEntity;
import com.gendeathrow.hatchery.core.config.ConfigLootHandler;
import com.gendeathrow.hatchery.core.init.ModBlocks;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.core.jei.eggmachine.EggMachineCategory;
import com.gendeathrow.hatchery.core.jei.eggmachine.EggMachineWrapper;
import com.gendeathrow.hatchery.core.jei.fertilizermixer.FertilizerMixerCategory;
import com.gendeathrow.hatchery.core.jei.fertilizermixer.FertilizerMixerRecipeWrapper;
import com.gendeathrow.hatchery.core.jei.generator.GeneratorCategory;
import com.gendeathrow.hatchery.core.jei.generator.GeneratorRecipeWrapper;
import com.gendeathrow.hatchery.core.jei.luckyegg.LuckyEggCategory;
import com.gendeathrow.hatchery.core.jei.luckyegg.LuckyEggWrapper;
import com.gendeathrow.hatchery.core.jei.nestingpen.NestingPenCategory;
import com.gendeathrow.hatchery.core.jei.shredder.ShredderCategory;
import com.gendeathrow.hatchery.modaddons.ChickensHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@JEIPlugin
public class JEIPllugin
implements IModPlugin {
    IJeiHelpers jeiHelpers;
    IGuiHelper guiHelper;
    IIngredientRegistry ingredientRegistry;
    private ShredderCategory shredderCat;
    private NestingPenCategory nestingCat;
    private EggMachineCategory eggmachineCat;
    private LuckyEggCategory luckyEggCat;
    private FertilizerMixerCategory mixerCat;
    private GeneratorCategory genCat;

    public void register(IModRegistry registry) {
        ItemStack stack;
        this.jeiHelpers = registry.getJeiHelpers();
        this.guiHelper = this.jeiHelpers.getGuiHelper();
        this.ingredientRegistry = registry.getIngredientRegistry();
        for (Block block : ModBlocks.BLOCKS) {
            stack = new ItemStack(block, 1, Short.MAX_VALUE);
            if (stack.func_190926_b()) continue;
            registry.addDescription(stack, new String[]{"jei." + block.func_149739_a()});
        }
        for (Item item : ModItems.ITEMS) {
            stack = new ItemStack(item, 1, Short.MAX_VALUE);
            if (stack.func_190926_b()) continue;
            registry.addDescription(stack, new String[]{"jei." + item.func_77658_a()});
        }
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.chickenmachine), new String[]{"hatchery.eggmachine.egg"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.shredder), new String[]{"hatchery.shredder.recipe"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.pen), new String[]{"hatchery.nesting_pen.drops"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.fertilizerMixer), new String[]{"hatchery.fertilizermixer.recipe"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.digesterGenerator), new String[]{"hatchery.generator.recipe"});
        registry.handleRecipes(ShredderRecipe.class, (IRecipeWrapperFactory)this.shredderCat, "hatchery.shredder.recipe");
        registry.addRecipes(this.getShredderRecipes(), "hatchery.shredder.recipe");
        registry.handleRecipes(NestingPenDropRecipe.class, (IRecipeWrapperFactory)this.nestingCat, "hatchery.nesting_pen.drops");
        if (ChickensHelper.isLoaded()) {
            registry.addRecipes(ChickensHelper.getChickensModDropRecipes(this.nestingCat), "hatchery.nesting_pen.drops");
        }
        registry.addRecipes(this.getVanillaDropRecipe(), "hatchery.nesting_pen.drops");
        registry.addRecipes((Collection)new ArrayList<IRecipeWrapper>(){
            {
                this.add(new EggMachineWrapper());
            }
        }, "hatchery.eggmachine.egg");
        registry.addRecipes(this.getLuckyEggs(), "hatchery.luckyeggs.drop");
        ArrayList<FertilizerMixerRecipeWrapper> mixer = new ArrayList<FertilizerMixerRecipeWrapper>();
        mixer.add(new FertilizerMixerRecipeWrapper(new ItemStack(ModItems.manure)));
        mixer.add(new FertilizerMixerRecipeWrapper(new ItemStack(ModBlocks.manureBlock)));
        registry.addRecipes(mixer, "hatchery.fertilizermixer.recipe");
        registry.addRecipes((Collection)new ArrayList<GeneratorRecipeWrapper>(){
            {
                this.add(new GeneratorRecipeWrapper());
            }
        }, "hatchery.generator.recipe");
        IIngredientBlacklist itemBlacklist = registry.getJeiHelpers().getIngredientBlacklist();
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.guiHelper = registry.getJeiHelpers().getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.nestingCat = new NestingPenCategory(this.guiHelper);
        iRecipeCategoryArray[0] = this.nestingCat;
        registry.addRecipeCategories(iRecipeCategoryArray);
        IRecipeCategory[] iRecipeCategoryArray2 = new IRecipeCategory[1];
        this.shredderCat = new ShredderCategory(this.guiHelper);
        iRecipeCategoryArray2[0] = this.shredderCat;
        registry.addRecipeCategories(iRecipeCategoryArray2);
        IRecipeCategory[] iRecipeCategoryArray3 = new IRecipeCategory[1];
        this.luckyEggCat = new LuckyEggCategory(this.guiHelper);
        iRecipeCategoryArray3[0] = this.luckyEggCat;
        registry.addRecipeCategories(iRecipeCategoryArray3);
        IRecipeCategory[] iRecipeCategoryArray4 = new IRecipeCategory[1];
        this.eggmachineCat = new EggMachineCategory(this.guiHelper);
        iRecipeCategoryArray4[0] = this.eggmachineCat;
        registry.addRecipeCategories(iRecipeCategoryArray4);
        IRecipeCategory[] iRecipeCategoryArray5 = new IRecipeCategory[1];
        this.mixerCat = new FertilizerMixerCategory(this.guiHelper);
        iRecipeCategoryArray5[0] = this.mixerCat;
        registry.addRecipeCategories(iRecipeCategoryArray5);
        IRecipeCategory[] iRecipeCategoryArray6 = new IRecipeCategory[1];
        this.genCat = new GeneratorCategory(this.guiHelper);
        iRecipeCategoryArray6[0] = this.genCat;
        registry.addRecipeCategories(iRecipeCategoryArray6);
    }

    public void onRuntimeAvailable(IJeiRuntime arg0) {
    }

    public void registerIngredients(IModIngredientRegistration arg0) {
    }

    public void registerItemSubtypes(ISubtypeRegistry arg0) {
    }

    private List<LuckyEggWrapper> getLuckyEggs() {
        ArrayList<LuckyEggWrapper> recipes = new ArrayList<LuckyEggWrapper>();
        ArrayList<ItemStack> droplist = new ArrayList<ItemStack>();
        Iterator<ConfigLootHandler.ItemDrop> itr = ConfigLootHandler.drops.iterator();
        while (itr.hasNext()) {
            ConfigLootHandler.ItemDrop item = itr.next();
            droplist.add(item.getItemStack());
            if (droplist.size() != 36 && itr.hasNext()) continue;
            recipes.add(new LuckyEggWrapper(droplist));
            droplist.clear();
        }
        return recipes;
    }

    private List<IRecipeWrapper> getShredderRecipes() {
        ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
        for (ShredderRecipe recipe : ShredderTileEntity.shredderRecipes) {
            recipes.add(this.shredderCat.getRecipeWrapper(recipe));
        }
        return recipes;
    }

    private List<IRecipeWrapper> getVanillaDropRecipe() {
        ResourceLocation name = EntityList.func_191306_a(EntityChicken.class);
        ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
        if (EntityList.field_75627_a.containsKey(name)) {
            ItemStack chicken = new ItemStack(Items.field_151063_bx);
            ItemMonsterPlacer.func_185078_a((ItemStack)chicken, (ResourceLocation)name);
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            output.add(new ItemStack(Items.field_151110_aK));
            output.add(new ItemStack(ModItems.manure));
            output.add(new ItemStack(Items.field_151008_G));
            recipes.add(this.nestingCat.getRecipeWrapper(new NestingPenDropRecipe((EntityLivingBase)new EntityChicken(null), chicken, output)));
        }
        return recipes;
    }
}

