/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.entities;

import com.gendeathrow.hatchery.Hatchery;
import com.gendeathrow.hatchery.core.Settings;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.entities.ai.EntityAIRoosterMating;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class EntityRooster
extends EntityChicken {
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{ModItems.chickenFeed, Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    InventoryStroageModifiable inventory = new InventoryStroageModifiable("Items", 1);
    public static final int SEED_SLOT = 0;
    public static final int MAX_SEEDS = 20;
    private static final DataParameter<Integer> SEEDS = EntityDataManager.func_187226_a(EntityRooster.class, (DataSerializer)DataSerializers.field_187192_b);
    private int angryTimer = 0;

    public EntityRooster(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SEEDS, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRoosterMating(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityRooster.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityOcelot.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(8.0);
    }

    public void setAngryTarget(EntityLivingBase entityIn) {
        this.func_70604_c(entityIn);
    }

    public boolean isAngry() {
        return this.func_142015_aE() > 0;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70888_h = this.field_70886_e;
        this.field_70884_g = this.field_70883_f;
        this.field_70883_f = (float)((double)this.field_70883_f + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.field_70883_f = MathHelper.func_76131_a((float)this.field_70883_f, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.field_70889_i < 1.0f) {
            this.field_70889_i = 1.0f;
        }
        this.field_70889_i = (float)((double)this.field_70889_i * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.field_70886_e += this.field_70889_i * 2.0f;
        if (this.field_70173_aa % 5 == 0 && !this.field_70170_p.field_72995_K) {
            this.convertSeeds();
        }
        this.field_70887_j = 500;
        if (this.isAngry()) {
            --this.angryTimer;
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (hand == EnumHand.MAIN_HAND && (stack.func_190926_b() || stack.func_77973_b() instanceof ItemSeeds)) {
                player.openGui((Object)Hatchery.INSTANCE, 1, player.field_70170_p, this.func_145782_y(), 0, 0);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return otherAnimal == this ? false : (!(otherAnimal instanceof EntityChicken) || otherAnimal instanceof EntityRooster ? false : this.func_70880_s() && otherAnimal.func_70880_s());
    }

    public EntityRooster createChild(EntityAgeable entityageable) {
        return null;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public static void loadTemptationItems() {
        ArrayList<Item> itemlist = new ArrayList<Item>();
        for (String tempString : Settings.TEMPTATION_ITEMS) {
            Item item;
            if (tempString == null || (item = Item.func_111206_d((String)tempString)) == null) continue;
            itemlist.add(item);
        }
        if (!itemlist.isEmpty()) {
            EntityRooster.addTemptationItems(itemlist);
        }
    }

    protected static void addTemptationItems(ArrayList<Item> itemlist) {
        for (Item item : itemlist) {
            if (TEMPTATION_ITEMS.contains(item)) continue;
            TEMPTATION_ITEMS.add(item);
        }
    }

    public void convertSeeds() {
        if (this.getHasSeeds() && this.getSeeds() <= 18) {
            this.setSeeds(this.getSeeds() + 2);
            this.inventory.getStackInSlot(0).func_190918_g(2);
        }
    }

    public boolean getHasSeeds() {
        return !this.inventory.getStackInSlot(0).func_190926_b() && TEMPTATION_ITEMS.contains(this.inventory.getStackInSlot(0).func_77973_b()) && this.inventory.getStackInSlot(0).func_190916_E() >= 2;
    }

    public void setSeeds(int size) {
        this.field_70180_af.func_187227_b(SEEDS, (Object)size);
    }

    public int getSeeds() {
        return (Integer)this.field_70180_af.func_187225_a(SEEDS);
    }

    public int getScaledSeeds(int scale) {
        return this.getSeeds() != 0 ? (int)((float)this.getSeeds() / 20.0f * (float)scale) : 0;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Seeds", this.getSeeds());
        this.inventory.writeToNBT(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSeeds(nbt.func_74762_e("Seeds"));
        this.inventory.readFromNBT(nbt);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    static class AITargetAggressor
    extends EntityAINearestAttackableTarget<EntityLiving> {
        public AITargetAggressor(EntityRooster rooster) {
            super((EntityCreature)rooster, EntityLiving.class, true);
        }

        public boolean func_75250_a() {
            return ((EntityRooster)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }
}

