/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.entities.ai;

import com.gendeathrow.hatchery.core.Settings;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.entities.EntityRooster;
import com.gendeathrow.hatchery.item.HatcheryEgg;
import com.gendeathrow.hatchery.util.ItemStackEntityNBTHelper;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityAIRoosterMating
extends EntityAIBase {
    private final EntityRooster roosterEntity;
    World theWorld;
    private EntityAnimal targetChicken;
    int spawnBabyDelay;
    double moveSpeed;

    public EntityAIRoosterMating(EntityRooster animal, double speedIn) {
        this.roosterEntity = animal;
        this.theWorld = animal.field_70170_p;
        this.moveSpeed = speedIn;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.roosterEntity.func_70874_b() != 0 || this.roosterEntity.getSeeds() < 2) {
            return false;
        }
        this.targetChicken = this.getNearbyMate();
        return this.targetChicken != null;
    }

    public void func_75249_e() {
        if (this.targetChicken.func_70874_b() == 0) {
            ItemStack stack = new ItemStack(Items.field_151014_N);
            EntityPlayer player = EntityAIRoosterMating.getPlayer(this.theWorld);
            player.func_184611_a(EnumHand.MAIN_HAND, stack);
            this.rightClickItemAt(player, EnumHand.MAIN_HAND, stack);
        }
    }

    public boolean func_75253_b() {
        return this.targetChicken.func_70089_S() && this.targetChicken.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetChicken = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.roosterEntity.func_70671_ap().func_75651_a((Entity)this.targetChicken, 10.0f, (float)this.roosterEntity.func_70646_bf());
        this.roosterEntity.func_70661_as().func_75497_a((Entity)this.targetChicken, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.roosterEntity.func_70068_e((Entity)this.targetChicken) < 9.0) {
            this.spawnChild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rightClickItemAt(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (this.theWorld.field_72995_K || stack.func_190926_b() || stack.func_77973_b() == null) {
            return false;
        }
        try {
            boolean bl = this.targetChicken.func_184645_a(player, EnumHand.MAIN_HAND);
            return bl;
        }
        finally {
            this.roosterEntity.func_184645_a(player, EnumHand.MAIN_HAND);
            this.roosterEntity.setSeeds(this.roosterEntity.getSeeds() - 2);
        }
    }

    public static EntityPlayer getPlayer(World world) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        return FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rooster".getBytes()), "rooster"));
    }

    private void spawnChild() {
        EntityAgeable entityageable = this.targetChicken.func_90011_a((EntityAgeable)this.targetChicken);
        if (entityageable != null) {
            EntityPlayerMP entityplayer = this.targetChicken.func_191993_do();
            this.roosterEntity.func_70873_a(100);
            this.targetChicken.func_70873_a(6000);
            this.roosterEntity.func_70875_t();
            this.targetChicken.func_70875_t();
            entityageable.func_70873_a(-24000);
            entityageable.func_70012_b(this.targetChicken.field_70165_t, this.targetChicken.field_70163_u, this.targetChicken.field_70161_v, 0.0f, 0.0f);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this.roosterEntity, (EntityLiving)this.targetChicken, entityageable);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            entityageable = event.getChild();
            if (cancelled) {
                this.roosterEntity.func_70873_a(0);
                this.targetChicken.func_70873_a(6000);
                this.roosterEntity.func_70875_t();
                this.targetChicken.func_70875_t();
                return;
            }
            if (Settings.IS_EGG_BREEDING) {
                ItemStack egg = new ItemStack(ModItems.hatcheryEgg, 1, 0);
                ItemStackEntityNBTHelper.addEntitytoItemStack(egg, (EntityLiving)entityageable);
                egg.func_151001_c(entityageable.func_145748_c_().func_150254_d() + " egg");
                HatcheryEgg.setColor(egg, (Entity)entityageable);
                EntityItem entityItem = new EntityItem(this.theWorld, this.targetChicken.field_70165_t, this.targetChicken.field_70163_u, this.targetChicken.field_70161_v, egg);
                this.theWorld.func_72838_d((Entity)entityItem);
            } else {
                this.theWorld.func_72838_d((Entity)entityageable);
            }
            Random random = this.targetChicken.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)this.targetChicken.field_70130_N * 2.0 - (double)this.targetChicken.field_70130_N;
                double d4 = 0.5 + random.nextDouble() * (double)this.targetChicken.field_70131_O;
                double d5 = random.nextDouble() * (double)this.targetChicken.field_70130_N * 2.0 - (double)this.targetChicken.field_70130_N;
                this.theWorld.func_175688_a(EnumParticleTypes.HEART, this.targetChicken.field_70165_t + d3, this.targetChicken.field_70163_u + d4, this.targetChicken.field_70161_v + d5, d0, d1, d2, new int[0]);
            }
            if (this.theWorld.func_82736_K().func_82766_b("doMobLoot")) {
                this.theWorld.func_72838_d((Entity)new EntityXPOrb(this.theWorld, this.roosterEntity.field_70165_t, this.roosterEntity.field_70163_u, this.roosterEntity.field_70161_v, random.nextInt(7) + 1));
            }
        }
    }

    private EntityAnimal getNearbyMate() {
        List list = this.theWorld.func_72872_a(EntityChicken.class, this.roosterEntity.func_174813_aQ().func_72321_a(8.0, 8.0, 8.0));
        double d0 = Double.MAX_VALUE;
        EntityAnimal entityanimal = null;
        for (EntityAnimal entityanimal1 : list) {
            if (!this.roosterEntity.func_70685_l((Entity)entityanimal1) || !(this.roosterEntity.func_70068_e((Entity)entityanimal1) < d0) || entityanimal1 instanceof EntityRooster || !entityanimal1.func_70880_s() && entityanimal1.func_70874_b() != 0) continue;
            entityanimal = entityanimal1;
            d0 = this.roosterEntity.func_70068_e((Entity)entityanimal1);
        }
        return entityanimal;
    }
}

