/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.modaddons;

import com.gendeathrow.hatchery.api.crafting.NestingPenDropRecipe;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.core.jei.nestingpen.NestingPenCategory;
import com.gendeathrow.hatchery.util.RegisterEggsUtil;
import com.setycz.chickens.ChickensMod;
import com.setycz.chickens.entity.EntityChickensChicken;
import com.setycz.chickens.item.ItemSpawnEgg;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Optional.InterfaceList(value={@Optional.Interface(iface="com.setycz.chickens.ChickensMod", modid="chickens"), @Optional.Interface(iface="com.setycz.chickens.entity.EntityChickensChicken", modid="chickens"), @Optional.Interface(iface="com.setycz.chickens.item.ItemSpawnEgg", modid="chickens"), @Optional.Interface(iface="com.setycz.chickens.registry.ChickensRegistry", modid="chickens"), @Optional.Interface(iface="com.setycz.chickens.registry.ChickensRegistryItem", modid="chickens")})
public class ChickensHelper {
    public static final String ChickensModID = "chickens";
    @GameRegistry.ObjectHolder(value="chickens:analyzer")
    public static Item chickenAnalyzer;
    @GameRegistry.ObjectHolder(value="chickens:spawn_egg")
    public static Item spawnEgg;

    public static boolean isLoaded() {
        return Loader.isModLoaded((String)ChickensModID);
    }

    @Nullable
    @Optional.Method(modid="chickens")
    public static HashMap<String, Integer> getChickenStats(Entity entity) {
        EntityChickensChicken chicken;
        if (entity instanceof EntityChickensChicken && ((chicken = (EntityChickensChicken)entity).getStatsAnalyzed() || ChickensMod.instance.getAlwaysShowStats())) {
            HashMap<String, Integer> list = new HashMap<String, Integer>();
            list.put("entity.ChickensChicken.growth", chicken.getGrowth());
            list.put("entity.ChickensChicken.gain", chicken.getGain());
            list.put("entity.ChickensChicken.strength", chicken.getStrength());
            return list;
        }
        return null;
    }

    @Optional.Method(modid="chickens")
    public static boolean checkForAnalyzer(ItemStack stack, Entity entity) {
        if (chickenAnalyzer == null || stack.func_190926_b() || entity == null) {
            return false;
        }
        if (stack.func_77973_b() == chickenAnalyzer && entity instanceof EntityChickensChicken) {
            EntityChickensChicken chicken = (EntityChickensChicken)entity;
            if (chicken.getStatsAnalyzed()) {
                return false;
            }
            chicken.setStatsAnalyzed(true);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="chickens")
    public static EntityLiving getChickenFromEgg(ItemStack spawnEgg, World worldIn, BlockPos pos) {
        if (spawnEgg == null || worldIn == null) {
            return null;
        }
        EntityChickensChicken entitychicken = new EntityChickensChicken(worldIn);
        entitychicken.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entitychicken.field_70759_as = entitychicken.field_70177_z;
        entitychicken.field_70761_aq = entitychicken.field_70177_z;
        entitychicken.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entitychicken)), (IEntityLivingData)null);
        entitychicken.setChickenType(ItemSpawnEgg.getTypeFromStack((ItemStack)spawnEgg));
        return entitychicken;
    }

    @Optional.Method(modid="chickens")
    public static void spawnChickenType(World world, BlockPos pos, String registryName) {
        EntityChickensChicken entitychicken = new EntityChickensChicken(world);
        entitychicken.setChickenType(registryName);
        entitychicken.func_70873_a(-24000);
        entitychicken.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)entitychicken);
    }

    @Nullable
    @Optional.Method(modid="chickens")
    public static String getDyeChickenfromItemStack(ItemStack itemStack) {
        ChickensRegistryItem chicken = ChickensRegistry.findDyeChicken((int)itemStack.func_77960_j());
        if (chicken == null) {
            return null;
        }
        return chicken.getRegistryName().toString();
    }

    public static List<IRecipeWrapper> getChickensModDropRecipes(NestingPenCategory nestingCat) {
        if (ChickensHelper.isLoaded()) {
            return ChickensHelper.getDropRecipes(nestingCat);
        }
        return null;
    }

    @Optional.Method(modid="chickens")
    private static List<IRecipeWrapper> getDropRecipes(NestingPenCategory nestingCat) {
        ArrayList<IRecipeWrapper> recipes = new ArrayList<IRecipeWrapper>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            output.add(chicken.createLayItem());
            output.add(new ItemStack(ModItems.manure));
            output.add(new ItemStack(Items.field_151008_G));
            output.add(new ItemStack(ModItems.hatcheryEgg));
            EntityChickensChicken entity = new EntityChickensChicken(null);
            entity.setChickenType(chicken.getRegistryName().toString());
            ItemStack spawnEgg = new ItemStack(ChickensMod.spawnEgg, 1);
            ItemSpawnEgg.applyEntityIdToItemStack((ItemStack)spawnEgg, (ResourceLocation)chicken.getRegistryName());
            recipes.add(nestingCat.getRecipeWrapper(new NestingPenDropRecipe((EntityLivingBase)entity, spawnEgg, output)));
        }
        return recipes;
    }

    @Optional.Method(modid="chickens")
    public static int getChickensColor(String type) {
        if (ChickensRegistry.getByRegistryName((String)type) == null || FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return 14667419;
        }
        if (ChickensRegistry.getByRegistryName((String)type).isDye()) {
            return RegisterEggsUtil.getRGB(EnumDyeColor.func_176766_a((int)ChickensRegistry.getByRegistryName((String)type).getDyeMetadata()).func_193349_f());
        }
        return ChickensRegistry.getByRegistryName((String)type).getBgColor();
    }
}

