/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.storage;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryStroageModifiable
extends ItemStackHandler {
    public String ID = "Items";

    public InventoryStroageModifiable() {
        this(1);
    }

    public InventoryStroageModifiable(String ID, int size) {
        this(size);
        this.ID = ID;
    }

    public InventoryStroageModifiable(int size) {
        super(size);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.canInsertSlot(slot, stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack insertItemFirstAvaliableSlot(ItemStack stack, boolean simulate) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.insertItem(i, stack, true) == stack) continue;
            return this.insertItem(i, stack, false);
        }
        return stack;
    }

    public ItemStack getAndRemoveSlot(int slot) {
        ItemStack extract = this.getStackInSlot(slot).func_77946_l();
        if (!extract.func_190926_b()) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        return extract;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canExtractSlot(slot)) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    public boolean canExtractSlot(int slot) {
        return true;
    }

    public boolean canInsertSlot(int slot, ItemStack stack) {
        return true;
    }

    public void dropInventory(World world, BlockPos pos) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getAndRemoveSlot(i);
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), stack));
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tags = nbt.func_74775_l(this.ID);
        this.deserializeNBT(tags);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tags = this.serializeNBT();
        nbt.func_74782_a(this.ID, (NBTBase)tags);
        return nbt;
    }

    public static int calcRedstoneFromInventory(@Nullable InventoryStroageModifiable inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

