/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TeleportHelper {
    private static final int DEFAULT_RND_TP_DISTANCE = 16;
    private static Random rand = new Random();

    public static boolean teleportRandomly(EntityLivingBase entity, int distance) {
        double d0 = entity.field_70165_t + (rand.nextDouble() - 0.5) * (double)distance;
        double d1 = entity.field_70163_u + (double)rand.nextInt(distance + 1) - (double)(distance / 2);
        double d2 = entity.field_70161_v + (rand.nextDouble() - 0.5) * (double)distance;
        return TeleportHelper.teleportTo(entity, d0, d1, d2, false);
    }

    public static boolean teleportRandomly(EntityLivingBase entity) {
        return TeleportHelper.teleportRandomly(entity, 16);
    }

    public static boolean teleportToEntity(EntityLivingBase entity, Entity toEntity) {
        Vec3d vec3 = new Vec3d(entity.field_70165_t - toEntity.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - toEntity.field_70163_u + (double)toEntity.func_70047_e(), entity.field_70161_v - toEntity.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = entity.field_70165_t + (rand.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = entity.field_70163_u + (double)(rand.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = entity.field_70161_v + (rand.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return TeleportHelper.teleportTo(entity, d1, d2, d3, false);
    }

    public static boolean teleportTo(EntityLivingBase entity, double x, double y, double z, boolean fireEndermanEvent) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (fireEndermanEvent && MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double origX = entity.field_70165_t;
        double origY = entity.field_70163_u;
        double origZ = entity.field_70161_v;
        entity.field_70165_t = event.getTargetX();
        entity.field_70163_u = event.getTargetY();
        entity.field_70161_v = event.getTargetZ();
        int xInt = MathHelper.func_76128_c((double)entity.field_70165_t);
        int yInt = Math.max(2, MathHelper.func_76128_c((double)entity.field_70163_u));
        int zInt = MathHelper.func_76128_c((double)entity.field_70161_v);
        boolean doTeleport = false;
        World worldObj = entity.func_130014_f_();
        if (worldObj.func_175668_a(new BlockPos(xInt, yInt, zInt), true)) {
            boolean foundGround = false;
            while (!foundGround && yInt > 2) {
                IBlockState bs = worldObj.func_180495_p(new BlockPos(xInt, yInt - 1, zInt));
                if (bs != null && bs.func_177230_c() != null && bs.func_185904_a().func_76230_c()) {
                    foundGround = true;
                    continue;
                }
                entity.field_70163_u -= 1.0;
                --yInt;
            }
            if (foundGround) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (worldObj.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !worldObj.func_72953_d(entity.func_174813_aQ())) {
                    doTeleport = true;
                } else if (yInt <= 0) {
                    doTeleport = false;
                }
            }
        }
        if (!doTeleport) {
            entity.func_70107_b(origX, origY, origZ);
            return false;
        }
        entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = origX + (entity.field_70165_t - origX) * d6 + (rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d8 = origY + (entity.field_70163_u - origY) * d6 + rand.nextDouble() * (double)entity.field_70131_O;
            double d9 = origZ + (entity.field_70161_v - origZ) * d6 + (rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            worldObj.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        worldObj.func_184134_a(origX, origY, origZ, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }
}

