/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity.render;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderFallenMount
extends RenderHorse {
    public static final Factory FACTORY = new Factory();
    private static final String[] horseArmorTextures = new String[]{null, "textures/entity/horse/armor/horse_armor_iron.png", "textures/entity/horse/armor/horse_armor_gold.png", "textures/entity/horse/armor/horse_armor_diamond.png"};
    private static final String textureName = "textures/entity/horse/horse_zombie.png";
    private static final ResourceLocation zombieHorseTexture = new ResourceLocation("textures/entity/horse/horse_zombie.png");
    private static final Map<String, ResourceLocation> textureCache = Maps.newHashMap();

    public RenderFallenMount(RenderManager rm) {
        super(rm);
    }

    protected ResourceLocation func_110775_a(EntityHorse horse) {
        if (horse.func_70658_aO() == 0) {
            return zombieHorseTexture;
        }
        return this.getArmoredTexture(horse);
    }

    private ResourceLocation getArmoredTexture(EntityHorse horse) {
        String s = horseArmorTextures[horse.func_184783_dl().ordinal()];
        ResourceLocation resourcelocation = textureCache.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation("Layered:" + s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new LayeredTexture(new String[]{textureName, s}));
            textureCache.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    public static class Factory
    implements IRenderFactory<EntityHorse> {
        public Render<? super EntityHorse> createRenderFor(RenderManager manager) {
            return new RenderFallenMount(manager);
        }
    }
}

