/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.potion;

import com.google.common.base.Predicate;
import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.potion.FloatingPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Potions {
    private static final String WITHERING = "withering";
    private static final String WITHERING_LONG = "witheringLong";
    private static final String CONFUSION = "confusion";
    private static final String CONFUSION_LONG = "confusionLong";
    private static final String FLOATING = "floating";
    private static final String FLOATING_TWO = "floatingTwo";
    private static final String FLOATING_LONG = "floatingLong";
    private PotionType withering = (PotionType)new PotionType("withering", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 900)}).setRegistryName("enderzoo", "withering");
    private PotionType witheringLong = (PotionType)new PotionType("withering", new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 2400)}).setRegistryName("enderzoo", "witheringLong");
    private PotionType confusion = (PotionType)new PotionType("confusion", new PotionEffect[]{new PotionEffect(MobEffects.field_76431_k, 900)}).setRegistryName("enderzoo", "confusion");
    private PotionType confusionLong = (PotionType)new PotionType("confusion", new PotionEffect[]{new PotionEffect(MobEffects.field_76431_k, 2400)}).setRegistryName("enderzoo", "confusionLong");
    private PotionType floating;
    private PotionType floatingLong;
    private PotionType floatingTwo;
    private FloatingPotion floatingPotion;

    public Potions() {
        if (Config.floatingPotionEnabled) {
            this.floatingPotion = FloatingPotion.create();
            this.floating = (PotionType)new PotionType(FLOATING, new PotionEffect[]{new PotionEffect((Potion)this.floatingPotion, Config.floatingPotionDuration)}).setRegistryName("enderzoo", FLOATING);
            this.floatingLong = (PotionType)new PotionType(FLOATING, new PotionEffect[]{new PotionEffect((Potion)this.floatingPotion, Config.floatingPotionDurationLong)}).setRegistryName("enderzoo", FLOATING_TWO);
            this.floatingTwo = (PotionType)new PotionType(FLOATING, new PotionEffect[]{new PotionEffect((Potion)this.floatingPotion, Config.floatingPotionTwoDuration, 1)}).setRegistryName("enderzoo", FLOATING_LONG);
        }
    }

    public void registerPotions(IForgeRegistry<PotionType> reg) {
        Ingredient redstone = Ingredient.func_193367_a((Item)Items.field_151137_ax);
        Ingredient glowstone = Ingredient.func_193367_a((Item)Items.field_151114_aO);
        reg.register((IForgeRegistryEntry)this.withering);
        reg.register((IForgeRegistryEntry)this.witheringLong);
        Ingredient witheringDust = Ingredient.func_193367_a((Item)EnderZoo.itemWitheringDust);
        this.registerPotionTypeConversion(PotionTypes.field_185233_e, witheringDust, this.withering);
        this.registerPotionTypeConversion(this.withering, redstone, this.witheringLong);
        reg.register((IForgeRegistryEntry)this.confusion);
        reg.register((IForgeRegistryEntry)this.confusionLong);
        Ingredient confusionDust = Ingredient.func_193367_a((Item)EnderZoo.itemConfusingDust);
        this.registerPotionTypeConversion(PotionTypes.field_185233_e, confusionDust, this.confusion);
        this.registerPotionTypeConversion(this.confusion, redstone, this.confusionLong);
        if (Config.floatingPotionEnabled) {
            reg.register((IForgeRegistryEntry)this.floating);
            reg.register((IForgeRegistryEntry)this.floatingLong);
            reg.register((IForgeRegistryEntry)this.floatingTwo);
            Ingredient owlEgg = Ingredient.func_193367_a((Item)EnderZoo.itemOwlEgg);
            this.registerPotionTypeConversion(PotionTypes.field_185233_e, owlEgg, this.floating);
            this.registerPotionTypeConversion(this.floating, redstone, this.floatingLong);
            this.registerPotionTypeConversion(this.floating, glowstone, this.floatingTwo);
        }
    }

    private void registerPotionTypeConversion(PotionType input, Ingredient ingredient, PotionType output) {
        PotionHelper.func_193356_a((PotionType)input, (Ingredient)ingredient, (PotionType)output);
    }

    public PotionType getWithering() {
        return this.withering;
    }

    public PotionType getWitheringLong() {
        return this.witheringLong;
    }

    public PotionType getConfusion() {
        return this.confusion;
    }

    public PotionType getConfusionLong() {
        return this.confusionLong;
    }

    public PotionType getFloating() {
        return this.floating;
    }

    public PotionType getFloatingLong() {
        return this.floatingLong;
    }

    public PotionType getFloatingTwo() {
        return this.floatingTwo;
    }

    public FloatingPotion getFloatingPotion() {
        return this.floatingPotion;
    }

    static class ItemPredicateInstance
    implements Predicate<ItemStack> {
        private final Item item;
        private final int meta;

        public ItemPredicateInstance(Item itemIn) {
            this(itemIn, -1);
        }

        public ItemPredicateInstance(Item itemIn, int metaIn) {
            this.item = itemIn;
            this.meta = metaIn;
        }

        public boolean apply(ItemStack p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.func_77973_b() == this.item && (this.meta == -1 || this.meta == p_apply_1_.func_77960_j());
        }
    }
}

