/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.api.multiblock;

import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class MultiblockFormEvent
extends BlockEvent {
    private final Multiblock multiblock;

    public MultiblockFormEvent(World world, BlockPos pos, IBlockState state, Multiblock multiblock) {
        super(world, pos, state);
        this.multiblock = multiblock;
    }

    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    public static enum Multiblock {
        PYLON("pylon");

        private static final Map<String, Multiblock> MAP;
        private String name;

        private Multiblock(String name) {
            this.name = name;
        }

        public static Multiblock getMultiblock(String name) {
            return MAP.get(name);
        }

        public boolean equals(Multiblock multiblock) {
            return this == multiblock;
        }

        public boolean equals(String name) {
            return this.getName().equals(name);
        }

        public String getName() {
            return this.name;
        }

        static {
            MAP = new TreeMap<String, Multiblock>();
            for (Multiblock multiblock1 : Multiblock.values()) {
                MAP.put(multiblock1.name, multiblock1);
            }
        }
    }
}

