/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import matteroverdrive.blocks.BlockBoundingBox;
import matteroverdrive.blocks.includes.MOBlockMachine;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.tile.TileEntityMachineChargingStation;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class BlockChargingStation
extends MOBlockMachine<TileEntityMachineChargingStation> {
    public static final PropertyBool CTM = PropertyBool.func_177716_a((String)"ctm");

    public BlockChargingStation(Material material, String name) {
        super(material, name);
        this.func_149711_c(20.0f);
        this.func_149752_b(9.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setHasGui(true);
        this.setHasRotation();
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_DIRECTION, CTM});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)CTM, (Comparable)Boolean.valueOf(Loader.isModLoaded((String)"ctm")));
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, BlockPos pos, boolean returnDrops) {
        return super.dismantleBlock(player, world, pos, returnDrops);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.func_180495_p(pos.func_177982_a(0, 1, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, 1, 0)) && world.func_180495_p(pos.func_177982_a(0, 2, 0)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177982_a(0, 2, 0));
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        BlockBoundingBox.createBoundingBox(worldIn, pos.func_177982_a(0, 1, 0), pos, this);
        BlockBoundingBox.createBoundingBox(worldIn, pos.func_177982_a(0, 2, 0), pos, this);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState blockState) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMachineChargingStation) {
            ((TileEntityMachineChargingStation)te).getBoundingBlocks().forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
        }
        super.func_180663_b(world, pos, blockState);
    }

    @Override
    public Class<TileEntityMachineChargingStation> getTileEntityClass() {
        return TileEntityMachineChargingStation.class;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityMachineChargingStation();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        super.onConfigChanged(config);
        TileEntityMachineChargingStation.BASE_MAX_RANGE = config.getInt("charge station range", "machine options", 8, "The range of the Charge Station");
    }
}

