/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.blocks;

import javax.annotation.Nonnull;
import matteroverdrive.blocks.includes.MOMatterEnergyStorageBlock;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.machines.replicator.ComponentTaskProcessingReplicator;
import matteroverdrive.machines.replicator.TileEntityMachineReplicator;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockReplicator
extends MOMatterEnergyStorageBlock<TileEntityMachineReplicator> {
    public float replication_volume;
    public boolean hasVentParticles;

    public BlockReplicator(Material material, String name) {
        super(material, name, true, true);
        this.setHasRotation();
        this.func_149711_c(20.0f);
        this.func_149713_g(2);
        this.func_149752_b(9.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setHasGui(true);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean isSideSolid(IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public Class<TileEntityMachineReplicator> getTileEntityClass() {
        return TileEntityMachineReplicator.class;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityMachineReplicator();
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        super.onConfigChanged(config);
        this.replication_volume = (float)config.getMachineDouble(this.func_149739_a(), "volume.replicate", 1.0, "The volume of the replication animation");
        this.hasVentParticles = config.getMachineBool(this.func_149739_a(), "particles.vent", true, "Should vent particles be displayed");
        TileEntityMachineReplicator.MATTER_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.matter", 1024, "How much matter can the replicator hold");
        TileEntityMachineReplicator.ENERGY_STORAGE = config.getMachineInt(this.func_149739_a(), "storage.energy", 512000, "How much energy can the replicator hold");
        ComponentTaskProcessingReplicator.REPLICATE_ENERGY_PER_MATTER = config.getMachineInt(this.func_149739_a(), "cost.replication.energy", 16000, "The total replication cost of each matter value. The energy cost is calculated like so: (matterAmount*EnergyCost)");
        ComponentTaskProcessingReplicator.REPLICATE_SPEED_PER_MATTER = config.getMachineInt(this.func_149739_a(), "speed.replication", 120, "The replication speed in ticks per matter value");
    }
}

