/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.TextureMapMO;
import matteroverdrive.client.data.TextureAtlasSpriteParticle;
import matteroverdrive.client.render.IWorldLastRenderer;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.ITextureMapPopulator;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderParticlesHandler
implements IWorldLastRenderer,
ITextureMapPopulator {
    public static ResourceLocation star = new ResourceLocation("matteroverdrive", "sprite_star");
    public static ResourceLocation shockwave = new ResourceLocation("matteroverdrive", "sprite_shockwave");
    public static ResourceLocation selection = new ResourceLocation("matteroverdrive", "sprite_selection");
    public static ResourceLocation marker = new ResourceLocation("matteroverdrive", "sprite_marker");
    public static ResourceLocation sparks = new ResourceLocation("matteroverdrive", "sprite_sparks");
    public static ResourceLocation blood = new ResourceLocation("matteroverdrive", "sprite_blood");
    public static ResourceLocation smoke = new ResourceLocation("matteroverdrive", "sprite_smoke");
    public static ResourceLocation explosion = new ResourceLocation("matteroverdrive", "sprite_explosion");
    protected final World world;
    final List<Particle>[] particles;
    private final TextureMapMO textureMap;
    private final ResourceLocation sheet = new ResourceLocation("matteroverdrive", "textures/particle/mo_particles.png");
    private final TextureManager renderer;
    private Random rand = new Random();

    public RenderParticlesHandler(World world, TextureManager renderer) {
        this.world = world;
        this.renderer = renderer;
        this.particles = new List[Blending.values().length];
        this.textureMap = new TextureMapMO("textures/particle", this);
        try {
            this.textureMap.func_174943_a(Minecraft.func_71410_x().func_110442_L(), this);
            renderer.func_110580_a(this.sheet, (ITickableTextureObject)this.textureMap);
            for (int i = 0; i < Blending.values().length; ++i) {
                this.particles[i] = new ArrayList<Particle>();
            }
            this.textureMap.func_110571_b(Minecraft.func_71410_x().func_110442_L());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRenderWorldLast(RenderHandler renderHandler, RenderWorldLastEvent event) {
        this.renderParticles((Entity)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks());
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Minecraft.func_71410_x().func_147113_T()) {
            this.updateEffects();
        }
    }

    public void addEffect(Particle particle, Blending blendingLayer) {
        this.particles[blendingLayer.ordinal()].add(particle);
    }

    private void updateEffects() {
        for (List<Particle> particleList : this.particles) {
            if (particleList == null || particleList.isEmpty()) continue;
            for (int j = 0; j < particleList.size(); ++j) {
                Particle particle = particleList.get(j);
                try {
                    if (particle != null) {
                        particle.func_189213_a();
                    }
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
                    crashreportcategory.func_189529_a("Particle", () -> ((Particle)particle).toString());
                    throw new ReportedException(crashreport);
                }
                if (particle != null && particle.func_187113_k()) continue;
                particleList.remove(j--);
            }
        }
    }

    public void renderParticles(Entity entity, float f) {
        float f1 = ActiveRenderInfo.func_178808_b();
        float f2 = ActiveRenderInfo.func_178803_d();
        float f3 = ActiveRenderInfo.func_178805_e();
        float f4 = ActiveRenderInfo.func_178807_f();
        float f5 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)f;
        Particle.field_70554_ao = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)f;
        Particle.field_70555_ap = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        Frustum camera = new Frustum();
        camera.func_78547_a(Particle.field_70556_an, Particle.field_70554_ao, Particle.field_70555_ap);
        this.renderer.func_110577_a(this.sheet);
        block12: for (int k = 0; k < this.particles.length; ++k) {
            if (this.particles.length <= k || this.particles[k] == null || this.particles[k].isEmpty()) continue;
            BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
            Blending blending = Blending.values()[k];
            switch (blending) {
                case Additive: {
                    GlStateManager.func_179120_a((int)1, (int)1, (int)0, (int)1);
                    wr.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    break;
                }
                case Additive2Sided: {
                    GlStateManager.func_179120_a((int)1, (int)1, (int)0, (int)1);
                    GlStateManager.func_179129_p();
                    wr.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    break;
                }
                case LinesAdditive: {
                    GlStateManager.func_179120_a((int)1, (int)1, (int)0, (int)1);
                    GlStateManager.func_179090_x();
                    GL11.glLineWidth((float)2.0f);
                    wr.func_181668_a(1, DefaultVertexFormats.field_181704_d);
                    break;
                }
                case Transparent: {
                    GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                    wr.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                }
            }
            for (int j = 0; j < this.particles[k].size(); ++j) {
                Particle particle = this.particles[k].get(j);
                if (particle == null) continue;
                try {
                    AxisAlignedBB bb = particle.func_187116_l();
                    if (!camera.func_78546_a(bb)) continue;
                    particle.func_180434_a(wr, null, f, f1, f5, f2, f3, f4);
                    continue;
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                    crashreportcategory.func_189529_a("Particle", () -> ((Particle)particle).toString());
                    throw new ReportedException(crashreport);
                }
            }
            Tessellator.func_178181_a().func_78381_a();
            switch (blending) {
                case Additive2Sided: {
                    GlStateManager.func_179089_o();
                    continue block12;
                }
                case LinesAdditive: {
                    GlStateManager.func_179098_w();
                }
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void func_177059_a(TextureMap iconRegistry) {
        this.reg(iconRegistry, sparks);
        this.reg(iconRegistry, star);
        this.reg(iconRegistry, shockwave);
        this.reg(iconRegistry, marker);
        this.reg(iconRegistry, selection);
        this.reg(iconRegistry, blood, 64, 2);
        this.reg(iconRegistry, smoke, 64, 2);
        this.reg(iconRegistry, explosion, 21, 2);
    }

    public void reg(TextureMap textureMap, ResourceLocation resourceLocation) {
        textureMap.func_174942_a(resourceLocation);
    }

    public void reg(TextureMap textureMap, ResourceLocation resourceLocation, int frameSize, int speed) {
        TextureAtlasSpriteParticle spriteParticle = new TextureAtlasSpriteParticle(resourceLocation.toString(), frameSize, speed);
        textureMap.setTextureEntry((TextureAtlasSprite)spriteParticle);
    }

    public TextureAtlasSprite getSprite(ResourceLocation location) {
        return this.textureMap.func_110572_b(location.toString());
    }

    public void bindSheet() {
        RenderUtils.bindTexture(this.sheet);
    }

    public static enum Blending {
        Additive,
        Additive2Sided,
        LinesAdditive,
        Transparent;

    }
}

