/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.biostat;

import matteroverdrive.Reference;
import matteroverdrive.api.renderer.IBioticStatRenderer;
import matteroverdrive.data.biostats.BioticStatShield;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.init.OverdriveBioticStats;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJLoader;
import org.lwjgl.util.vector.Vector3f;

public class BioticStatRendererShield
implements IBioticStatRenderer<BioticStatShield> {
    public static final ResourceLocation model_path = new ResourceLocation("matteroverdrive:models/shield_sphere.obj");
    private static final ResourceLocation forcefield_damage_tex = new ResourceLocation("matteroverdrive:textures/fx/shield_damage.png");
    private static final ResourceLocation forcefield_tex = new ResourceLocation("matteroverdrive:textures/fx/forcefield_plasma.png");
    private static final ResourceLocation forcefield_plasma_tex = new ResourceLocation("matteroverdrive:textures/fx/forcefield_plasma_2.png");
    private static final ResourceLocation shield_texture = new ResourceLocation("matteroverdrive:textures/fx/shield.png");
    IModel normal_sphere;
    IModel shield_model;
    IBakedModel baked_normal_sphere;
    IBakedModel baked_shield_model;
    private float opacityLerp;

    public BioticStatRendererShield() {
        try {
            this.shield_model = OBJLoader.INSTANCE.loadModel(model_path);
            this.normal_sphere = OBJLoader.INSTANCE.loadModel(new ResourceLocation("matteroverdrive:models/block/sphere.obj"));
            this.baked_shield_model = this.shield_model.bake(this.shield_model.getDefaultState(), DefaultVertexFormats.field_176600_a, arg_0 -> ((TextureMap)Minecraft.func_71410_x().func_147117_R()).func_174942_a(arg_0));
            this.baked_normal_sphere = this.normal_sphere.bake(this.shield_model.getDefaultState(), DefaultVertexFormats.field_176600_a, arg_0 -> ((TextureMap)Minecraft.func_71410_x().func_147117_R()).func_174942_a(arg_0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.opacityLerp = 0.0f;
    }

    @Override
    public void onWorldRender(BioticStatShield stat, int level, RenderWorldLastEvent event) {
        for (Object entity : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
            this.renderPlayerShield(event, (EntityPlayer)entity);
        }
    }

    private void renderPlayerShield(RenderWorldLastEvent event, EntityPlayer player) {
        AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player);
        boolean isVisible = this.manageOpacityLerp(androidPlayer, event.getPartialTicks());
        if (isVisible) {
            double time = Minecraft.func_71410_x().field_71441_e.func_72820_D();
            GlStateManager.func_179094_E();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_179112_b((int)1, (int)1);
            Vec3d playerPosition = player.func_174824_e(event.getPartialTicks());
            Vec3d clientPosition = Minecraft.func_71410_x().field_71439_g.func_174824_e(event.getPartialTicks());
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.2f * this.getOpacityLerp(player));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(shield_texture);
            if (!this.isClient(player)) {
                GlStateManager.func_179137_b((double)0.0, (double)((double)player.field_70131_O - 0.5), (double)0.0);
                GlStateManager.func_179089_o();
            } else if (Minecraft.func_71410_x().field_71474_y.field_74320_O > 0) {
                GlStateManager.func_179089_o();
            }
            GlStateManager.func_179137_b((double)(playerPosition.field_72450_a - clientPosition.field_72450_a), (double)(playerPosition.field_72448_b - clientPosition.field_72448_b), (double)(playerPosition.field_72449_c - clientPosition.field_72449_c));
            GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            GlStateManager.func_179114_b((float)((float)player.field_70179_y * 45.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)player.field_70159_w * 45.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)player.field_70170_p, this.baked_shield_model, Blocks.field_150350_a.func_176223_P(), BlockPos.field_177992_a, bufferbuilder, false);
            tessellator.func_78381_a();
            GlStateManager.func_179129_p();
            this.renderAttacks(androidPlayer);
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.1f * this.getOpacityLerp(player));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(forcefield_tex);
            GlStateManager.func_179139_a((double)1.02, (double)1.02, (double)1.02);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)player.field_70170_p, this.baked_normal_sphere, Blocks.field_150350_a.func_176223_P(), BlockPos.field_177992_a, bufferbuilder, false);
            tessellator.func_78381_a();
            RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 0.05f * this.getOpacityLerp(player));
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)((float)time * 0.005f), (float)((float)Math.sin(time * 0.01)), (float)((float)Math.cos(time * 0.01)), (float)0.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(forcefield_plasma_tex);
            GlStateManager.func_179139_a((double)1.01, (double)1.01, (double)1.01);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)player.field_70170_p, this.baked_normal_sphere, Blocks.field_150350_a.func_176223_P(), BlockPos.field_177992_a, bufferbuilder, false);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
            GlStateManager.func_179141_d();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    private boolean manageOpacityLerp(AndroidPlayer androidPlayer, float partialTicks) {
        if (OverdriveBioticStats.shield.getShieldState(androidPlayer)) {
            if (this.isClient(androidPlayer.getPlayer()) && this.opacityLerp < 1.0f) {
                this.opacityLerp = Math.min(1.0f, this.opacityLerp + partialTicks * 0.1f);
            }
            return true;
        }
        if (this.isClient(androidPlayer.getPlayer()) && this.opacityLerp > 0.0f) {
            this.opacityLerp = Math.max(0.0f, this.opacityLerp - partialTicks * 0.2f);
            return true;
        }
        return false;
    }

    private boolean isClient(EntityPlayer player) {
        return player == Minecraft.func_71410_x().field_71439_g;
    }

    private float getOpacityLerp(EntityPlayer player) {
        if (Minecraft.func_71410_x().field_71439_g == player) {
            return this.opacityLerp;
        }
        return 1.0f;
    }

    private void renderAttacks(AndroidPlayer androidPlayer) {
        float opacity = this.getOpacityLerp(androidPlayer.getPlayer());
    }

    private void renderAttack(Vector3f dir, float percent) {
        GlStateManager.func_179094_E();
        Vector3f front = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f c = Vector3f.cross((Vector3f)dir, (Vector3f)front, null);
        double omega = Math.acos(Vector3f.dot((Vector3f)dir, (Vector3f)front));
        GlStateManager.func_179114_b((float)((float)(omega * 57.29577951308232)), (float)c.x, (float)c.y, (float)c.z);
        RenderUtils.applyColorWithMultipy(Reference.COLOR_HOLO, 1.0f * percent);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(forcefield_damage_tex);
        GlStateManager.func_179121_F();
    }
}

