/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.entity;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import matteroverdrive.entity.monster.EntityRougeAndroidMob;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityRendererRougeAndroid<T extends EntityRougeAndroidMob>
extends RenderBiped<T> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("matteroverdrive:textures/entities/android.png");
    public static final ResourceLocation TEXTURE_HOLOGRAM = new ResourceLocation("matteroverdrive:textures/entities/android_holo.png");
    public static final ResourceLocation TEXTURE_COLORLESS = new ResourceLocation("matteroverdrive:textures/entities/android_colorless.png");
    public static final List<String> NAMES = Arrays.asList("the_codedone", "chairosto", "buuz135");
    private final boolean hologram;

    public EntityRendererRougeAndroid(RenderManager renderManager, ModelBiped modelBiped, float f, boolean hologram) {
        super(renderManager, modelBiped, f);
        this.hologram = hologram;
    }

    public EntityRendererRougeAndroid(RenderManager renderManager, boolean hologram) {
        this(renderManager, new ModelBiped(), 0.0f, hologram);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        if (entity.func_145818_k_() && NAMES.contains(TextFormatting.func_110646_a((String)((EntityRougeAndroidMob)entity).func_95999_t().toLowerCase()))) {
            return TEXTURE_COLORLESS;
        }
        if (this.hologram) {
            return TEXTURE_HOLOGRAM;
        }
        return TEXTURE;
    }

    protected boolean canRenderName(T entity) {
        return ((EntityRougeAndroidMob)entity).getTeam() != null || Minecraft.func_71410_x().field_71439_g.func_70032_d(entity) < 18.0f;
    }

    protected void preRenderCallback(T entity, float partialTicks) {
        if (((EntityRougeAndroidMob)entity).getIsLegendary()) {
            GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
        }
        if (entity.func_145818_k_() && NAMES.contains(TextFormatting.func_110646_a((String)((EntityRougeAndroidMob)entity).func_95999_t().toLowerCase()))) {
            float speed = 72.0f;
            int hsb = (int)((float)((EntityRougeAndroidMob)entity).field_70170_p.func_82737_E() % speed);
            Color color = Color.getHSBColor((float)hsb / speed, 0.5f, 1.0f);
            GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        }
        super.func_77041_b(entity, partialTicks);
    }
}

