/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.tileentity;

import java.util.ArrayList;
import matteroverdrive.Reference;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.tile.TileEntityGravitationalAnomaly;
import matteroverdrive.tile.TileEntityMachineGravitationalStabilizer;
import matteroverdrive.util.RenderUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityRendererGravitationalStabilizer
extends TileEntitySpecialRenderer<TileEntityMachineGravitationalStabilizer> {
    public static final ResourceLocation beam = new ResourceLocation("matteroverdrive:textures/fx/physbeam.png");

    public void render(TileEntityMachineGravitationalStabilizer stabilizer, double x, double y, double z, float ticks, int destroyStage, float a) {
        if (stabilizer.getHit() != null) {
            RayTraceResult hit = stabilizer.getHit();
            TileEntity tileEntityHit = stabilizer.func_145831_w().func_175625_s(hit.func_178782_a());
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            long time = stabilizer.func_145831_w().func_72820_D();
            double pulseSize = Math.sin((double)time * 0.2) * 0.001;
            Vector3f source = new Vector3f((float)stabilizer.func_174877_v().func_177958_n(), (float)stabilizer.func_174877_v().func_177956_o(), (float)stabilizer.func_174877_v().func_177952_p());
            Vector3f destination = new Vector3f((float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
            Vector3f dir = Vector3f.sub((Vector3f)destination, (Vector3f)source, null);
            Vector3f dirC = Vector3f.cross((Vector3f)dir, (Vector3f)new Vector3f(1.0f, 0.0f, 1.0f), null);
            float distance = dir.length();
            dir.normalise(dir);
            Vector3f front = new Vector3f(0.0f, 0.0f, -1.0f);
            Vector3f c = Vector3f.cross((Vector3f)dir, (Vector3f)front, null);
            double omega = Math.acos(Vector3f.dot((Vector3f)dir, (Vector3f)front));
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            RenderUtils.disableLightmap();
            GlStateManager.func_179112_b((int)1, (int)1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179124_c((float)((float)stabilizer.getBeamColorR()), (float)((float)stabilizer.getBeamColorG()), (float)((float)stabilizer.getBeamColorB()));
            this.func_147499_a(beam);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)((double)dirC.x * pulseSize + 1.0), (double)((double)dirC.y * pulseSize + 1.0), (double)((double)dirC.z * pulseSize + 1.0));
            GlStateManager.func_179109_b((float)(dir.x * distance / 2.0f), (float)(dir.y * distance / 2.0f), (float)(dir.z * distance / 2.0f));
            GlStateManager.func_179152_a((float)(dir.x * distance + 1.0f), (float)(dir.y * distance + 1.0f), (float)(dir.z * distance + 1.0f));
            GlStateManager.func_179114_b((float)((float)(omega * 57.29577951308232)), (float)c.x, (float)c.y, (float)c.z);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
            RenderUtils.drawPlaneWithUV(1.0, 1.0, 0.0, 0.0, distance / 2.0f, 1.0);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(dir.x * distance / 2.0f), (float)(dir.y * distance / 2.0f), (float)(dir.z * distance / 2.0f));
            GlStateManager.func_179152_a((float)(destination.x - source.x + 1.0f), (float)(destination.y - source.y + 1.0f), (float)(destination.z - source.z + 1.0f));
            GlStateManager.func_179114_b((float)((float)(omega * 57.29577951308232)), (float)c.x, (float)c.y, (float)c.z);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
            RenderUtils.drawPlaneWithUV(1.0, 1.0, 0.0, 0.0, distance / 2.0f, 1.0);
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            RenderUtils.enableLightmap();
            GlStateManager.func_179121_F();
            if (tileEntityHit != null && tileEntityHit instanceof TileEntityGravitationalAnomaly) {
                this.renderScreen(x, y, z, stabilizer, (TileEntityGravitationalAnomaly)tileEntityHit);
            }
        }
    }

    public void renderScreen(double x, double y, double z, TileEntityMachineGravitationalStabilizer stabilizer, TileEntityGravitationalAnomaly anomaly) {
        EnumFacing side = (EnumFacing)anomaly.func_145831_w().func_180495_p(stabilizer.func_174877_v()).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
        RenderUtils.beginDrawinngBlockScreen(x, y, z, side, Reference.COLOR_HOLO, stabilizer);
        ArrayList<String> infos = new ArrayList<String>();
        anomaly.addInfo(anomaly.func_145831_w(), anomaly.func_174877_v().func_177958_n(), anomaly.func_174877_v().func_177956_o(), anomaly.func_174877_v().func_177952_p(), infos);
        RenderUtils.drawScreenInfoWithGlobalAutoSize(infos.toArray(new String[infos.size()]), Reference.COLOR_HOLO, side, 10, 10, 4.0f);
        RenderUtils.endDrawinngBlockScreen();
    }

    private FontRenderer fontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }
}

