/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.render.weapons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.render.weapons.WeaponItemRenderer;
import matteroverdrive.client.render.weapons.layers.IWeaponLayer;
import matteroverdrive.client.render.weapons.modules.IModuleRender;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.animation.MOEasing;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class WeaponRenderHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Map<Class<? extends IWeaponModule>, IModuleRender> moduleRenders = new HashMap<Class<? extends IWeaponModule>, IModuleRender>();
    private final List<IWeaponLayer> weaponLayers = new ArrayList<IWeaponLayer>();

    @SubscribeEvent
    public void onHandRender(RenderSpecificHandEvent event) {
        ItemStack weapon = event.getItemStack();
        if (event.getHand() == EnumHand.MAIN_HAND && !weapon.func_190926_b() && weapon.func_77973_b() instanceof EnergyWeapon) {
            boolean flag;
            event.setCanceled(true);
            GlStateManager.func_179086_m((int)256);
            EntityRenderer entityRenderer = this.mc.field_71460_t;
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            float f = 0.07f;
            Project.gluPerspective((float)35.0f, (float)((float)this.mc.field_71443_c / (float)this.mc.field_71440_d), (float)0.05f, (float)(this.mc.field_71474_y.field_151451_c * 32));
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179094_E();
            this.hurtCameraEffect(event.getPartialTicks());
            if (this.mc.field_71474_y.field_74336_f) {
                this.setupViewBobbing(event.getPartialTicks());
            }
            boolean bl = flag = this.mc.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)this.mc.func_175606_aa()).func_70608_bn();
            if (!(this.mc.field_71474_y.field_74320_O != 0 || flag || this.mc.field_71474_y.field_74319_N || this.mc.field_71442_b.func_78747_a())) {
                float zoomValue = MOEasing.Sine.easeInOut(ClientWeaponHandler.ZOOM_TIME, 0.0f, 1.0f, 1.0f);
                float recoilValue = MOEasing.Quad.easeInOut(ClientWeaponHandler.RECOIL_TIME, 0.0f, 1.0f, 1.0f) * MathHelper.func_76131_a((float)ClientWeaponHandler.RECOIL_AMOUNT, (float)0.0f, (float)20.0f);
                this.transformFirstPerson(zoomValue);
                WeaponItemRenderer model = this.getWeaponModel(weapon);
                if (model != null) {
                    EntityPlayerSP player = this.mc.field_71439_g;
                    float f1 = player.func_70678_g(event.getPartialTicks());
                    float f2 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * event.getPartialTicks();
                    float f3 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * event.getPartialTicks();
                    this.rotateAroundXAndY(f2, f3);
                    this.setLightmap(player);
                    this.rotateArm(model, player, event.getPartialTicks());
                    GlStateManager.func_179091_B();
                    entityRenderer.func_180436_i();
                    Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)Minecraft.func_71410_x().field_71439_g);
                    if (render instanceof RenderPlayer) {
                        GlStateManager.func_179094_E();
                        RenderUtils.bindTexture(player.func_110306_p());
                        model.transformHand(recoilValue, zoomValue);
                        model.renderHand((RenderPlayer)render);
                        GlStateManager.func_179121_F();
                    }
                    List<ItemStack> modules = MOInventoryHelper.getStacks(weapon);
                    this.transformFromModules(modules, model.getWeaponMetadata(), weapon, event.getPartialTicks(), zoomValue);
                    model.transformFirstPersonWeapon((EnergyWeapon)weapon.func_77973_b(), weapon, zoomValue, recoilValue);
                    this.renderWeaponAndModules(modules, model, weapon, event.getPartialTicks());
                    this.renderLayers(model.getWeaponMetadata(), weapon, event.getPartialTicks());
                    entityRenderer.func_175072_h();
                }
                RenderHelper.func_74518_a();
            }
            GlStateManager.func_179121_F();
            if (this.mc.field_71474_y.field_74336_f) {
                this.setupViewBobbing(event.getPartialTicks());
            }
        }
    }

    public WeaponItemRenderer getWeaponModel(ItemStack weaponStack) {
        IBakedModel bakedModel = this.mc.func_175599_af().func_175037_a().func_178089_a(weaponStack);
        if (bakedModel instanceof WeaponItemRenderer) {
            return (WeaponItemRenderer)bakedModel;
        }
        return null;
    }

    public void renderWeaponAndModules(List<ItemStack> modules, WeaponItemRenderer model, ItemStack weapon, float partialTicks) {
        this.renderWeapon(model, weapon);
        this.renderModules(modules, model.getWeaponMetadata(), weapon, partialTicks);
    }

    public void onModelBake(TextureMap textureMap, RenderHandler renderHandler) {
        for (IModuleRender render : this.moduleRenders.values()) {
            render.onModelBake(textureMap, renderHandler);
        }
    }

    public void onTextureStich(TextureMap textureMap, RenderHandler renderHandler) {
        for (IModuleRender render : this.moduleRenders.values()) {
            render.onTextureStich(textureMap, renderHandler);
        }
    }

    private void rotateAroundXAndY(float angleX, float angleY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private void setLightmap(EntityPlayerSP player) {
        int i = this.mc.field_71441_e.func_175626_b(new BlockPos(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), 0);
        float f = i & 0xFFFF;
        float f1 = i >> 16;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)f, (float)f1);
    }

    private void rotateArm(WeaponItemRenderer weaponItemRenderer, EntityPlayerSP player, float partialTicks) {
        float f = player.field_71164_i + (player.field_71155_g - player.field_71164_i) * partialTicks;
        float f1 = player.field_71163_h + (player.field_71154_f - player.field_71163_h) * partialTicks;
        GlStateManager.func_179114_b((float)((player.field_70125_A - f) * 0.1f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((player.field_70177_z - f1) * weaponItemRenderer.getHorizontalSpeed()), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void renderWeapon(WeaponItemRenderer model, ItemStack weapon) {
        this.renderModel(model, weapon);
    }

    private void transformFromModules(List<ItemStack> modules, WeaponMetadataSection weaponMeta, ItemStack weapon, float ticks, float zoomValue) {
        if (modules != null) {
            for (ItemStack module : modules) {
                IModuleRender render = this.moduleRenders.get(module.func_77973_b().getClass());
                if (render == null) continue;
                render.transformWeapon(weaponMeta, weapon, module, ticks, zoomValue);
            }
        }
    }

    private void renderModules(List<ItemStack> modules, WeaponMetadataSection weaponMeta, ItemStack weapon, float ticks) {
        if (modules != null) {
            for (ItemStack module : modules) {
                IModuleRender render = this.moduleRenders.get(module.func_77973_b().getClass());
                if (render == null) continue;
                GlStateManager.func_179094_E();
                render.renderModule(weaponMeta, weapon, module, ticks);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderLayers(WeaponMetadataSection weaponMeta, ItemStack weapon, float ticks) {
        for (IWeaponLayer layer : this.weaponLayers) {
            layer.renderLayer(weaponMeta, weapon, ticks);
        }
    }

    public void renderModel(IBakedModel model, ItemStack weapon) {
        if (model == null) {
            return;
        }
        RenderUtils.bindTexture(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(worldrenderer, model.func_188616_a(null, enumfacing, 0L), -1, weapon);
        }
        this.renderQuads(worldrenderer, model.func_188616_a(null, null, 0L), WeaponHelper.getColor(weapon), weapon);
        tessellator.func_78381_a();
    }

    public IBakedModel getItemModel(ItemStack weapon) {
        return this.mc.func_175599_af().func_175037_a().func_178089_a(weapon);
    }

    private void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColorSlow((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    @SubscribeEvent
    public void handleCameraRecoil(EntityViewRenderEvent.CameraSetup event) {
        event.setRoll(event.getRoll() + ClientWeaponHandler.CAMERA_RECOIL_AMOUNT * ClientWeaponHandler.CAMERA_RECOIL_TIME);
        event.setPitch(event.getPitch() + Math.abs(ClientWeaponHandler.CAMERA_RECOIL_AMOUNT) * ClientWeaponHandler.CAMERA_RECOIL_TIME * 0.5f);
    }

    private void transformFirstPerson(float zoomValue) {
        GlStateManager.func_179137_b((double)MOMathHelper.Lerp(0.13f, 0.0f, zoomValue), (double)-0.18, (double)-0.55);
        GlStateManager.func_179114_b((float)MOMathHelper.Lerp(185.0f, 180.0f, zoomValue), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)MOMathHelper.Lerp(3.0f, 0.0f, zoomValue), (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)0.8);
    }

    private void setupViewBobbing(float partialTicks) {
        if (this.mc.func_175606_aa() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.mc.func_175606_aa();
            float f = entityplayer.field_70140_Q - entityplayer.field_70141_P;
            float f1 = -(entityplayer.field_70140_Q + f * partialTicks);
            float f2 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * partialTicks;
            float f3 = entityplayer.field_70727_aS + (entityplayer.field_70726_aT - entityplayer.field_70727_aS) * partialTicks;
            GlStateManager.func_179109_b((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.05f), (float)(-Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2) * 0.1f), (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 1.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)f3, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void hurtCameraEffect(float partialTicks) {
        if (this.mc.func_175606_aa() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.mc.func_175606_aa();
            float f = (float)entitylivingbase.field_70737_aN - partialTicks;
            if (entitylivingbase.func_110143_aJ() <= 0.0f) {
                float f1 = (float)entitylivingbase.field_70725_aQ + partialTicks;
                GlStateManager.func_179114_b((float)(40.0f - 8000.0f / (f1 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (f < 0.0f) {
                return;
            }
            f /= (float)entitylivingbase.field_70738_aO;
            f = MathHelper.func_76126_a((float)(f * f * f * f * (float)Math.PI));
            float f2 = entitylivingbase.field_70739_aP;
            GlStateManager.func_179114_b((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-f * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    public void addModuleRender(Class<? extends IWeaponModule> moduleClass, IModuleRender render) {
        this.moduleRenders.put(moduleClass, render);
    }

    public void addWeaponLayer(IWeaponLayer layer) {
        this.weaponLayers.add(layer);
    }
}

