/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.client.resources.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import net.minecraft.client.resources.data.BaseMetadataSectionSerializer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.Vec3d;

public class WeaponMetadataSectionSerializer
extends BaseMetadataSectionSerializer
implements JsonSerializer<WeaponMetadataSection> {
    public String func_110483_a() {
        return "weapon";
    }

    public WeaponMetadataSection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        WeaponMetadataSection weaponMetadataSection = new WeaponMetadataSection();
        JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)json, (String)"metadata section");
        try {
            JsonObject modules = jsonobject.getAsJsonObject("modules");
            if (modules != null) {
                for (Map.Entry element : modules.entrySet()) {
                    weaponMetadataSection.setModulePosition((String)element.getKey(), this.fromJson(((JsonElement)element.getValue()).getAsJsonObject()));
                }
            }
        }
        catch (ClassCastException classcastexception) {
            throw new JsonParseException("Invalid weapon->scope_position: expected array, was " + jsonobject.get("scope_position"), (Throwable)classcastexception);
        }
        return weaponMetadataSection;
    }

    public JsonElement serialize(WeaponMetadataSection section, Type type, JsonSerializationContext context) {
        JsonObject jsonobject = new JsonObject();
        JsonObject modules = new JsonObject();
        for (Map.Entry<String, Vec3d> position : section.getModulePositions().entrySet()) {
            modules.add(position.getKey(), (JsonElement)this.toObject(position.getValue()));
        }
        jsonobject.add("modules", (JsonElement)modules);
        return jsonobject;
    }

    public JsonObject toObject(Vec3d vec3) {
        JsonObject object = new JsonObject();
        object.add("x", (JsonElement)new JsonPrimitive((Number)vec3.field_72450_a));
        object.add("y", (JsonElement)new JsonPrimitive((Number)vec3.field_72448_b));
        object.add("z", (JsonElement)new JsonPrimitive((Number)vec3.field_72449_c));
        return object;
    }

    public Vec3d fromJson(JsonObject object) {
        return new Vec3d(object.get("x").getAsDouble(), object.get("y").getAsDouble(), object.get("z").getAsDouble());
    }
}

