/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class AndoidCommands
extends CommandBase {
    public static String[] subCommands = new String[]{"set", "stats", "unlock", "forget"};

    public String func_71517_b() {
        return "android";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "android <command> <value> <player>";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] parameters) throws CommandException {
        EntityPlayerMP player;
        AndroidPlayer androidPlayer;
        if (parameters.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid Parameters"));
            return;
        }
        if (parameters.length >= 2 && (androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)(player = parameters.length >= 3 ? AndoidCommands.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)parameters[2]) : AndoidCommands.func_71521_c((ICommandSender)sender)))) != null) {
            boolean validCommand = false;
            String commandInfo = "";
            if (parameters[0].equalsIgnoreCase("set")) {
                boolean android = AndoidCommands.func_180527_d((String)parameters[1]);
                androidPlayer.setAndroid(android);
                validCommand = true;
                commandInfo = android ? sender.func_70005_c_() + " is now an Android" : sender.func_70005_c_() + " is no longer an Android";
            } else if (parameters[0].equalsIgnoreCase("stats")) {
                if (parameters[1].equalsIgnoreCase("reset")) {
                    androidPlayer.resetUnlocked();
                    validCommand = true;
                    commandInfo = sender.func_70005_c_() + " stats are now Reset";
                }
            } else if (parameters[0].equalsIgnoreCase("unlock")) {
                if (MatterOverdrive.STAT_REGISTRY.hasStat(parameters[1])) {
                    IBioticStat stat = MatterOverdrive.STAT_REGISTRY.getStat(parameters[1]);
                    androidPlayer.unlock(stat, stat.maxLevel());
                    validCommand = true;
                    commandInfo = sender.func_70005_c_() + " now has the ability " + TextFormatting.GREEN + "[" + stat.getDisplayName(androidPlayer, stat.maxLevel()) + "]";
                }
            } else if (parameters[0].equalsIgnoreCase("forget") && MatterOverdrive.STAT_REGISTRY.hasStat(parameters[1])) {
                IBioticStat stat = MatterOverdrive.STAT_REGISTRY.getStat(parameters[1]);
                androidPlayer.reset(stat);
                validCommand = true;
                commandInfo = TextFormatting.GREEN + "[" + stat.getDisplayName(androidPlayer, stat.maxLevel()) + "]" + TextFormatting.RESET + " removed from " + sender.func_70005_c_();
            }
            if (validCommand) {
                androidPlayer.sync(EnumSet.allOf(IAndroid.DataType.class), false);
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "[" + "MatterOverdrive: Legacy Edition" + "] " + TextFormatting.RESET + commandInfo));
                return;
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Invalid Android Command. Use /help to learn more."));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] parameters, @Nullable BlockPos targetPos) {
        ArrayList<String> commands;
        block6: {
            block4: {
                block7: {
                    block5: {
                        commands = new ArrayList<String>();
                        if (parameters.length != 2) break block4;
                        if (!parameters[0].equalsIgnoreCase("set")) break block5;
                        if ("true".startsWith(parameters[1])) {
                            commands.add("true");
                        }
                        if ("false".startsWith(parameters[1])) {
                            commands.add("false");
                        }
                        break block6;
                    }
                    if (!parameters[0].equalsIgnoreCase("stats")) break block7;
                    if ("reset".startsWith(parameters[1])) {
                        commands.add("reset");
                    }
                    break block6;
                }
                if (!parameters[0].equalsIgnoreCase("unlock") && !parameters[0].equalsIgnoreCase("forget")) break block6;
                commands.addAll(MatterOverdrive.STAT_REGISTRY.getStats().stream().map(IBioticStat::getUnlocalizedName).filter(s -> s.startsWith(parameters[1])).collect(Collectors.toList()));
                break block6;
            }
            for (String s2 : subCommands) {
                if (!s2.startsWith(parameters[0])) continue;
                commands.add(s2);
            }
        }
        return commands;
    }

    public boolean func_82358_a(String[] params, int index) {
        return index == 2;
    }
}

