/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.commands;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.IQuest;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class QuestCommands
extends CommandBase {
    private final Random random = new Random();

    public String func_71517_b() {
        return "quest";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "quest <action> [parameters] <name> <player>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] parameters) throws CommandException {
        if (parameters.length <= 0) throw new CommandException("Invalid command.", new Object[0]);
        if (parameters[0].equalsIgnoreCase("add")) {
            if (parameters.length <= 1) throw new CommandException("No random quest parameters.", new Object[0]);
            Object entityPlayer = parameters.length > 2 ? QuestCommands.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)parameters[2]) : commandSender.func_130014_f_().func_72924_a(commandSender.func_70005_c_());
            if (entityPlayer == null) throw new CommandException("Invalid Player.", new Object[0]);
            OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)entityPlayer);
            QuestStack questStack = MatterOverdrive.QUEST_FACTORY.generateQuestStack(parameters[1]);
            if (questStack == null) throw new CommandException("Could not find a quest with the given name.", new Object[0]);
            extendedProperties.addQuest(questStack);
            return;
        } else if (parameters[0].equalsIgnoreCase("remove")) {
            if (parameters.length <= 1) throw new CommandException("No remove quests parameters.", new Object[0]);
            Object entityPlayer = parameters.length > 2 ? QuestCommands.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)parameters[2]) : commandSender.func_130014_f_().func_72924_a(commandSender.func_70005_c_());
            if (entityPlayer == null) throw new CommandException("Invalid Player.", new Object[0]);
            OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)entityPlayer);
            if (parameters[1].equalsIgnoreCase("all")) {
                extendedProperties.getQuestData().clearActiveQuests();
                extendedProperties.getQuestData().clearCompletedQuests();
                extendedProperties.sync(EnumSet.allOf(PlayerQuestData.DataType.class));
                return;
            } else if (parameters[1].equalsIgnoreCase("active")) {
                extendedProperties.getQuestData().clearActiveQuests();
                extendedProperties.sync(EnumSet.of(PlayerQuestData.DataType.ACTIVE_QUESTS));
                return;
            } else {
                if (!parameters[1].equalsIgnoreCase("completed")) throw new CommandException("Invalid quest type.", new Object[0]);
                extendedProperties.getQuestData().clearCompletedQuests();
                extendedProperties.sync(EnumSet.of(PlayerQuestData.DataType.COMPLETED_QUESTS));
            }
            return;
        } else {
            if (!parameters[0].equalsIgnoreCase("contract")) throw new CommandException("Invalid quest command.", new Object[0]);
            if (parameters.length <= 1) return;
            IQuest quest = MatterOverdrive.QUESTS.getQuestByName(parameters[1]);
            if (quest == null) throw new CommandException("No such quest.", new Object[0]);
            Object entityPlayer = parameters.length > 2 ? QuestCommands.func_184888_a((MinecraftServer)server, (ICommandSender)commandSender, (String)parameters[2]) : commandSender.func_130014_f_().func_72924_a(commandSender.func_70005_c_());
            QuestStack questStack = MatterOverdrive.QUEST_FACTORY.generateQuestStack(this.random, quest);
            entityPlayer.field_71071_by.func_70441_a(questStack.getContract());
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> commands;
        block7: {
            block5: {
                block6: {
                    commands = new ArrayList<String>();
                    if (args.length != 2) break block5;
                    if (!args[0].equalsIgnoreCase("add") && !args[0].equalsIgnoreCase("contract")) break block6;
                    for (String questName : MatterOverdrive.QUESTS.getAllQuestName()) {
                        commands.add(questName);
                    }
                    break block7;
                }
                if (!args[0].equalsIgnoreCase("remove")) break block7;
                commands.add("all");
                commands.add("active");
                commands.add("completed");
                break block7;
            }
            if (args.length == 1) {
                commands.add("add");
                commands.add("remove");
                commands.add("contract");
            } else if (args.length == 3) {
                for (Object player : sender.func_130014_f_().field_73010_i) {
                    commands.add(((EntityPlayer)player).func_70005_c_());
                }
            }
        }
        return commands;
    }
}

