/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.container.matter_network;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.container.matter_network.ContainerTaskQueueMachine;
import matteroverdrive.container.matter_network.IMatterDatabaseMonitor;
import matteroverdrive.container.matter_network.IMatterDatabaseWatcher;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.data.matter_network.ItemPatternMapping;
import matteroverdrive.data.matter_network.MatterDatabaseEvent;
import matteroverdrive.gui.GuiPatternMonitor;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.pattern_monitor.TileEntityMachinePatternMonitor;
import matteroverdrive.network.packet.client.pattern_monitor.PacketClearPatterns;
import matteroverdrive.network.packet.client.pattern_monitor.PacketSendItemPattern;
import matteroverdrive.util.MOContainerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerPatternMonitor
extends ContainerTaskQueueMachine<TileEntityMachinePatternMonitor>
implements IMatterDatabaseWatcher {
    public ContainerPatternMonitor(InventoryPlayer inventory, TileEntityMachinePatternMonitor machine) {
        super(inventory, machine);
    }

    @Override
    public void init(InventoryPlayer inventory) {
        this.addAllSlotsFromInventory(((TileEntityMachinePatternMonitor)this.machine).getInventoryContainer());
        MOContainerHelper.AddPlayerSlots(inventory, this, 45, 89, false, true);
    }

    @SideOnly(value=Side.CLIENT)
    public void setItemPattern(ItemPatternMapping itemPattern) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiPatternMonitor) {
            ((GuiPatternMonitor)Minecraft.func_71410_x().field_71462_r).setPattern(itemPattern);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clearPatternStoragePatterns(BlockPos database, int storageId) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiPatternMonitor) {
            ((GuiPatternMonitor)Minecraft.func_71410_x().field_71462_r).clearPatterns(database, storageId);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clearDatabasePatterns(BlockPos blockPos) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiPatternMonitor) {
            ((GuiPatternMonitor)Minecraft.func_71410_x().field_71462_r).clearPatterns(blockPos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clearAllPatterns() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiPatternMonitor) {
            ((GuiPatternMonitor)Minecraft.func_71410_x().field_71462_r).clearPatterns();
        }
    }

    @Override
    public void onWatcherAdded(MOTileEntityMachine machine) {
        super.onWatcherAdded(machine);
        if (machine instanceof IMatterDatabaseMonitor) {
            this.sendAllPatterns((IMatterDatabaseMonitor)((Object)machine));
        }
    }

    private void sendAllPatterns(IMatterDatabaseMonitor monitor) {
        for (IMatterDatabase database : monitor.getConnectedDatabases()) {
            for (int d = 0; d < database.getPatternStorageCount(); ++d) {
                ItemStack storageStack = database.getPatternStorage(d);
                if (storageStack == null) continue;
                IMatterPatternStorage storage = (IMatterPatternStorage)storageStack.func_77973_b();
                for (int i = 0; i < storage.getCapacity(storageStack); ++i) {
                    MatterOverdrive.NETWORK.sendTo(new PacketSendItemPattern(this.field_75152_c, new ItemPatternMapping(storage.getPatternAt(storageStack, i), database.getPosition(), d, i)), (EntityPlayerMP)this.getPlayer());
                }
            }
        }
    }

    @Override
    public void onConnectToNetwork(IMatterDatabaseMonitor monitor) {
        this.sendAllPatterns(monitor);
    }

    @Override
    public void onDisconnectFromNetwork(IMatterDatabaseMonitor monitor) {
        MatterOverdrive.NETWORK.sendTo(new PacketClearPatterns(this.field_75152_c), (EntityPlayerMP)this.getPlayer());
    }

    @Override
    public void onDatabaseEvent(MatterDatabaseEvent event) {
        if (event instanceof MatterDatabaseEvent.Added) {
            this.onDatabaseAdded(event.database);
        } else if (event instanceof MatterDatabaseEvent.Removed) {
            this.onDatabaseRemoved(event.database);
        } else if (event instanceof MatterDatabaseEvent.PatternStorageChanged) {
            this.onPatternStorageChange(event.database, ((MatterDatabaseEvent.PatternStorageChanged)event).storageID);
        } else if (event instanceof MatterDatabaseEvent.PatternChanged) {
            this.onPatternChange(event.database, ((MatterDatabaseEvent.PatternChanged)event).patternStorageId, ((MatterDatabaseEvent.PatternChanged)event).patternId);
        }
    }

    private void onDatabaseAdded(IMatterDatabase database) {
        for (int d = 0; d < database.getPatternStorageCount(); ++d) {
            ItemStack storageStack = database.getPatternStorage(d);
            IMatterPatternStorage storage = (IMatterPatternStorage)storageStack.func_77973_b();
            for (int i = 0; i < storage.getCapacity(storageStack); ++i) {
                MatterOverdrive.NETWORK.sendTo(new PacketSendItemPattern(this.field_75152_c, new ItemPatternMapping(storage.getPatternAt(storageStack, i), database.getPosition(), d, i)), (EntityPlayerMP)this.getPlayer());
            }
        }
    }

    private void onDatabaseRemoved(IMatterDatabase database) {
        MatterOverdrive.NETWORK.sendTo(new PacketClearPatterns(this.field_75152_c, database.getPosition()), (EntityPlayerMP)this.getPlayer());
    }

    private void onPatternStorageChange(IMatterDatabase database, int patternStorage) {
        MatterOverdrive.NETWORK.sendTo(new PacketClearPatterns(this.field_75152_c, database.getPosition(), patternStorage), (EntityPlayerMP)this.getPlayer());
        ItemStack storageStack = database.getPatternStorage(patternStorage);
        if (storageStack != null) {
            IMatterPatternStorage storage = (IMatterPatternStorage)storageStack.func_77973_b();
            for (int i = 0; i < storage.getCapacity(storageStack); ++i) {
                MatterOverdrive.NETWORK.sendTo(new PacketSendItemPattern(this.field_75152_c, new ItemPatternMapping(storage.getPatternAt(storageStack, i), database.getPosition(), patternStorage, i)), (EntityPlayerMP)this.getPlayer());
            }
        }
    }

    private void onPatternChange(IMatterDatabase database, int patternStorage, int patternId) {
        ItemStack patternStorageStack = database.getPatternStorage(patternStorage);
        if (patternStorageStack != null && patternStorageStack.func_77973_b() instanceof IMatterPatternStorage) {
            ItemPattern itemPattern = ((IMatterPatternStorage)patternStorageStack.func_77973_b()).getPatternAt(patternStorageStack, patternId);
            MatterOverdrive.NETWORK.sendTo(new PacketSendItemPattern(this.field_75152_c, new ItemPatternMapping(itemPattern, database.getPosition(), patternStorage, patternId)), (EntityPlayerMP)this.getPlayer());
        }
    }

    public static class PatternMapping {
        private int storageId;
        private int patternId;
        private ItemPattern pattern;

        public PatternMapping(int storageId, int patternId, ItemPattern itemPattern) {
            this.storageId = storageId;
            this.patternId = patternId;
            this.pattern = itemPattern;
        }
    }
}

