/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.container.matter_network;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.container.ContainerMachine;
import matteroverdrive.container.matter_network.ITaskQueueWatcher;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.network.packet.client.task_queue.PacketSyncTaskQueue;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;

public class ContainerTaskQueueMachine<T extends MOTileEntityMachine>
extends ContainerMachine<T>
implements ITaskQueueWatcher {
    public ContainerTaskQueueMachine(InventoryPlayer inventory, T machine) {
        super(inventory, machine);
    }

    @Override
    public void onWatcherAdded(MOTileEntityMachine machine) {
        super.onWatcherAdded(machine);
        if (machine instanceof IMatterNetworkDispatcher) {
            this.sendAllTaskQueues((IMatterNetworkDispatcher)((Object)machine));
        }
    }

    private void sendAllTaskQueues(IMatterNetworkDispatcher dispatcher) {
        for (int i = 0; i < dispatcher.getTaskQueueCount(); ++i) {
            this.sendTaskQueue(dispatcher, i);
        }
    }

    private void sendTaskQueue(IMatterNetworkDispatcher dispatcher, int queueId) {
        MatterOverdrive.NETWORK.sendTo(new PacketSyncTaskQueue(dispatcher, queueId), (EntityPlayerMP)this.getPlayer());
    }

    @Override
    public void onTaskAdded(IMatterNetworkDispatcher dispatcher, long taskId, int queueId) {
        this.sendTaskQueue(dispatcher, queueId);
    }

    @Override
    public void onTaskRemoved(IMatterNetworkDispatcher dispatcher, long taskId, int queueId) {
        this.sendTaskQueue(dispatcher, queueId);
    }

    @Override
    public void onTaskChanged(IMatterNetworkDispatcher dispatcher, long taskId, int queueId) {
        this.sendTaskQueue(dispatcher, queueId);
    }
}

