/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data;

import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.items.includes.EnergyContainer;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.tile.MOTileEntityMachineEnergy;

public class MachineEnergyStorage<T extends MOTileEntityMachineEnergy>
extends EnergyContainer {
    protected final T machine;

    public MachineEnergyStorage(int capacity, T machine) {
        super(capacity);
        this.machine = machine;
    }

    public MachineEnergyStorage(int capacity, int maxTransfer, T machine) {
        super(capacity, maxTransfer);
        this.machine = machine;
    }

    public MachineEnergyStorage(int capacity, int maxReceive, int maxExtract, T machine) {
        super(capacity, maxReceive, maxExtract);
        this.machine = machine;
    }

    public MachineEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy, T machine) {
        super(capacity, maxReceive, maxExtract, energy);
        this.machine = machine;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int modifyEnergyStored(int amount) {
        if (amount > 0) {
            return this.receiveEnergy(amount, false);
        }
        if (amount < 0) {
            return this.extractEnergy(amount, false);
        }
        return 0;
    }

    @Override
    public int receiveEnergy(int amount, boolean simulate) {
        int ex = super.receiveEnergy(amount, simulate);
        if (ex != 0 && !simulate) {
            ((MOTileEntityMachineEnergy)this.machine).UpdateClientPower();
        }
        return ex;
    }

    @Override
    public int extractEnergy(int amount, boolean simulate) {
        int ex = super.extractEnergy(amount, simulate);
        if (ex != 0 && !simulate) {
            ((MOTileEntityMachineEnergy)this.machine).UpdateClientPower();
        }
        return ex;
    }

    public long getInputRate() {
        return (long)((double)this.maxReceive * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.PowerTransfer));
    }

    public long getOutputRate() {
        return (long)((double)this.maxExtract * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.PowerTransfer));
    }

    @Override
    public int getMaxEnergyStored() {
        return (int)((double)super.getMaxEnergyStored() * ((MOTileEntityMachine)this.machine).getUpgradeMultiply(UpgradeTypes.PowerStorage));
    }

    public int getMaxEnergyStoredUnaltered() {
        return super.getMaxEnergyStored();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

