/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.util.MOLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BioticStatAirDash
extends AbstractBioticStat {
    @SideOnly(value=Side.CLIENT)
    private int lastClickTime;
    @SideOnly(value=Side.CLIENT)
    private int clickCount;
    @SideOnly(value=Side.CLIENT)
    private boolean hasNotReleased;
    @SideOnly(value=Side.CLIENT)
    private boolean hasDashed;

    public BioticStatAirDash(String name, int xp) {
        super(name, xp);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (android.getPlayer().field_70170_p.field_72995_K) {
            this.manageDashing(android);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manageDashing(AndroidPlayer android) {
        EntityPlayerSP playerSP = (EntityPlayerSP)android.getPlayer();
        if (!playerSP.field_70122_E) {
            if (!this.hasDashed) {
                if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
                    if (!this.hasNotReleased) {
                        this.hasNotReleased = true;
                        if (this.lastClickTime > 0) {
                            ++this.clickCount;
                            MOLog.info("clickCount: %s", this.lastClickTime);
                        }
                        this.lastClickTime = 5;
                    }
                } else {
                    this.hasNotReleased = false;
                }
                if (this.clickCount >= 1) {
                    this.clickCount = 0;
                    this.dash(playerSP);
                    this.hasDashed = true;
                }
                if (this.lastClickTime > 0) {
                    --this.lastClickTime;
                }
            }
        } else {
            this.hasNotReleased = false;
            this.hasDashed = false;
            this.clickCount = 0;
            this.lastClickTime = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void dash(EntityPlayerSP playerSP) {
        Vec3d look = playerSP.func_70040_Z().func_72441_c(0.0, 0.75, 0.0).func_72432_b();
        playerSP.func_70024_g(look.field_72450_a, look.field_72448_b, look.field_72449_c);
        for (int i = 0; i < 30; ++i) {
            playerSP.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, playerSP.field_70165_t + playerSP.func_70681_au().nextGaussian() * 0.5, playerSP.field_70163_u + (double)(playerSP.func_70681_au().nextFloat() * playerSP.func_70047_e()), playerSP.field_70161_v + playerSP.func_70681_au().nextGaussian() * 0.5, -look.field_72450_a, -look.field_72449_c, -look.field_72449_c, new int[0]);
        }
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return false;
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }
}

