/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.util.EnumSet;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOEnergyHelper;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingEvent;

public class BioticStatCloak
extends AbstractBioticStat
implements IConfigSubscriber {
    private static int ENERGY_PER_TICK = 128;

    public BioticStatCloak(String name, int xp) {
        super(name, xp);
        this.setShowOnHud(true);
        this.setShowOnWheel(true);
    }

    @Override
    public String getDetails(int level) {
        return String.format(super.getDetails(level), TextFormatting.YELLOW.toString() + ENERGY_PER_TICK + MOEnergyHelper.ENERGY_UNIT + TextFormatting.GRAY);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
        if (!android.getPlayer().field_70170_p.field_72995_K) {
            if (this.isActive(android, level)) {
                if (!android.getPlayer().func_82150_aj()) {
                    android.getPlayer().field_70170_p.func_184148_a(null, android.getPlayer().field_70165_t, android.getPlayer().field_70163_u, android.getPlayer().field_70161_v, MatterOverdriveSounds.androidCloakOn, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                android.getPlayer().func_82142_c(true);
                android.extractEnergyScaled(ENERGY_PER_TICK);
            } else {
                if (android.getPlayer().func_82150_aj()) {
                    android.getPlayer().field_70170_p.func_184148_a(null, android.getPlayer().field_70165_t, android.getPlayer().field_70163_u, android.getPlayer().field_70161_v, MatterOverdriveSounds.androidCloakOff, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                android.getPlayer().func_82142_c(false);
            }
        }
    }

    @Override
    public void onActionKeyPress(AndroidPlayer android, int level, boolean server) {
        if (this.equals(android.getActiveStat()) && server) {
            this.setActive(android, level, !android.getAndroidEffects().getEffectBool(1));
        }
    }

    private void setActive(AndroidPlayer android, int level, boolean active) {
        android.getAndroidEffects().updateEffect(1, active);
        android.sync(EnumSet.of(IAndroid.DataType.EFFECTS), true);
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
        if (!this.isEnabled(androidPlayer, level) && this.isActive(androidPlayer, level)) {
            this.setActive(androidPlayer, level, false);
        }
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return androidPlayer.getAndroidEffects().getEffectBool(1) && !androidPlayer.getPlayer().func_184587_cr();
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public boolean isEnabled(AndroidPlayer androidPlayer, int level) {
        return super.isEnabled(androidPlayer, level) && androidPlayer.hasEnoughEnergyScaled(ENERGY_PER_TICK);
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.isActive(android, level);
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_TICK = config.getInt("cloak_energy_per_tick", "abilities", 128, "The energy cost of the Cloak");
    }
}

