/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.biostats;

import com.google.common.collect.Multimap;
import java.util.EnumSet;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.api.events.bionicStats.MOEventBionicStat;
import matteroverdrive.data.biostats.AbstractBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BioticStatHighJump
extends AbstractBioticStat
implements IConfigSubscriber {
    private static int ENERGY_PER_JUMP = 1024;

    public BioticStatHighJump(String name, int xp) {
        super(name, xp);
        this.setMaxLevel(2);
    }

    @Override
    public void onAndroidUpdate(AndroidPlayer android, int level) {
    }

    @Override
    public String getDetails(int level) {
        return MOStringHelper.translateToLocal(this.getUnlocalizedDetails(), TextFormatting.YELLOW.toString() + ENERGY_PER_JUMP + " FE" + TextFormatting.GRAY);
    }

    @Override
    public void onActionKeyPress(AndroidPlayer androidPlayer, int level, boolean server) {
        if (server && this.equals(androidPlayer.getActiveStat())) {
            androidPlayer.getAndroidEffects().updateEffect(8, !androidPlayer.getAndroidEffects().getEffectBool(8));
            androidPlayer.sync(EnumSet.of(IAndroid.DataType.EFFECTS));
        }
    }

    @Override
    public void onKeyPress(AndroidPlayer androidPlayer, int level, int keycode, boolean down) {
    }

    @Override
    public void onLivingEvent(AndroidPlayer androidPlayer, int level, LivingEvent event) {
        if (event instanceof LivingEvent.LivingJumpEvent && this.isActive(androidPlayer, level) && !MinecraftForge.EVENT_BUS.post((Event)new MOEventBionicStat(this, level, androidPlayer)) && !androidPlayer.getPlayer().func_70093_af()) {
            if (!event.getEntity().field_70170_p.field_72995_K) {
                androidPlayer.extractEnergyScaled(ENERGY_PER_JUMP * level);
            }
            Vec3d motion = new Vec3d(event.getEntityLiving().field_70159_w, event.getEntityLiving().field_70181_x, event.getEntityLiving().field_70179_y);
            motion = motion.func_72432_b().func_72441_c(0.0, 1.0, 0.0).func_72432_b();
            event.getEntityLiving().func_70024_g(motion.field_72450_a * 0.25 * (double)level, motion.field_72448_b * 0.25 * (double)level, motion.field_72449_c * 0.25 * (double)level);
        }
    }

    @Override
    public void changeAndroidStats(AndroidPlayer androidPlayer, int level, boolean enabled) {
    }

    @Override
    public Multimap<String, AttributeModifier> attributes(AndroidPlayer androidPlayer, int level) {
        return null;
    }

    @Override
    public boolean isEnabled(AndroidPlayer android, int level) {
        return super.isEnabled(android, level) && android.hasEnoughEnergyScaled(ENERGY_PER_JUMP) && android.getPlayer().field_70122_E;
    }

    @Override
    public boolean showOnHud(AndroidPlayer android, int level) {
        return this.isActive(android, level);
    }

    @Override
    public boolean showOnWheel(AndroidPlayer androidPlayer, int level) {
        return androidPlayer.getPlayer().func_70093_af();
    }

    @Override
    public boolean isActive(AndroidPlayer androidPlayer, int level) {
        return androidPlayer.getAndroidEffects().getEffectBool(8);
    }

    @Override
    public int getDelay(AndroidPlayer androidPlayer, int level) {
        return 0;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        ENERGY_PER_JUMP = config.getInt("high_jump_energy", "abilities", 1024, "The energy cost of each High Jump");
    }
}

