/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.inventory;

import javax.annotation.Nonnull;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.data.inventory.Slot;
import matteroverdrive.data.inventory.WeaponSlot;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModuleSlot
extends Slot {
    int type;
    WeaponSlot weaponSlot;

    public ModuleSlot(boolean isMainSlot, int type, WeaponSlot weaponSlot) {
        super(isMainSlot);
        this.type = type;
        this.weaponSlot = weaponSlot;
    }

    @Override
    public boolean isValidForSlot(ItemStack item) {
        switch (this.type) {
            case 0: {
                return MOEnergyHelper.isEnergyContainerItem(item) && !WeaponHelper.isWeapon(item);
            }
        }
        if (WeaponHelper.isWeaponModule(item) && ((IWeaponModule)item.func_77973_b()).getSlot(item) == this.type) {
            if (this.weaponSlot != null && !this.weaponSlot.getItem().func_190926_b() && this.weaponSlot.getItem().func_77973_b() instanceof IWeapon) {
                return ((IWeapon)this.weaponSlot.getItem().func_77973_b()).supportsModule(this.weaponSlot.getItem(), item);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setItem(@Nonnull ItemStack item) {
        super.setItem(item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public HoloIcon getHoloIcon() {
        switch (this.type) {
            case 0: {
                return ClientProxy.holoIcons.getIcon("battery");
            }
            case 1: {
                return ClientProxy.holoIcons.getIcon("color");
            }
            case 2: {
                return ClientProxy.holoIcons.getIcon("barrel");
            }
            case 3: {
                return ClientProxy.holoIcons.getIcon("sights");
            }
        }
        return ClientProxy.holoIcons.getIcon("module");
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }
}

