/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Random;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class AbstractQuestLogicRandomItem
extends AbstractQuestLogic {
    QuestItem[] items;
    boolean randomItem;
    boolean anyItem;

    protected void init(QuestItem[] questItems) {
        this.items = questItems;
        this.randomItem = true;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        JsonArray itemsElement = jsonObject.getAsJsonArray("items");
        this.items = new QuestItem[itemsElement.size()];
        for (int i = 0; i < itemsElement.size(); ++i) {
            this.items[i] = new QuestItem(itemsElement.get(i).getAsJsonObject());
        }
        this.randomItem = MOJsonHelper.getBool(jsonObject, "random", false);
        this.anyItem = MOJsonHelper.getBool(jsonObject, "any", false);
    }

    protected void initItemType(Random random, QuestStack questStack) {
        if (this.randomItem) {
            ArrayList<Integer> avalibleBlocks = new ArrayList<Integer>();
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack itemStack = this.items[i].getItemStack();
                if (itemStack == null) continue;
                avalibleBlocks.add(i);
            }
            if (avalibleBlocks.size() > 0) {
                this.setItemType(questStack, (Integer)avalibleBlocks.get(random.nextInt(avalibleBlocks.size())));
            }
        } else if (!this.anyItem) {
            for (int i = 0; i < this.items.length; ++i) {
                ItemStack itemStack = this.items[i].getItemStack();
                if (itemStack == null) continue;
                this.setItemType(questStack, i);
                return;
            }
        }
    }

    @Override
    public boolean canAccept(QuestStack questStack, EntityPlayer entityPlayer) {
        for (QuestItem item : this.items) {
            if (!item.canItemExist()) continue;
            return true;
        }
        return false;
    }

    public boolean matches(QuestStack questStack, ItemStack itemStack) {
        if (this.anyItem) {
            for (QuestItem item : this.items) {
                if (!item.matches(itemStack)) continue;
                return true;
            }
        } else {
            return this.items[this.getItemType(questStack)].matches(itemStack);
        }
        return false;
    }

    public String getItemName(QuestStack questStack) {
        if (this.anyItem) {
            String name = "";
            for (QuestItem item : this.items) {
                ItemStack itemStack = item.getItemStack();
                name = itemStack != null ? name + itemStack.func_82833_r() + ", " : name + "Unknown Item, ";
            }
            return name;
        }
        ItemStack itemStack = this.items[this.getItemType(questStack)].getItemStack();
        if (itemStack != null) {
            return itemStack.func_82833_r();
        }
        return "Unknown Item";
    }

    public int getItemType(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74771_c("ItemType");
        }
        return 0;
    }

    public void setItemType(QuestStack questStack, int itemType) {
        this.initTag(questStack);
        this.getTag(questStack).func_74774_a("ItemType", (byte)itemType);
    }

    public AbstractQuestLogicRandomItem setRandomItem(boolean randomItem) {
        this.randomItem = randomItem;
        return this;
    }
}

