/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.logic.AbstractQuestLogicRandomItem;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicItemInteract
extends AbstractQuestLogicRandomItem {
    boolean consumeItem;

    public QuestLogicItemInteract() {
    }

    public QuestLogicItemInteract(QuestItem item, boolean consumeItem) {
        this.consumeItem = consumeItem;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        this.consumeItem = MOJsonHelper.getBool(jsonObject, "consume", false);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        info = info.replace("$itemName", this.getItemName(questStack));
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.hasInteracted(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = objective.replace("$itemName", this.getItemName(questStack));
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof PlayerInteractEvent.RightClickItem) {
            boolean isSameItem;
            PlayerInteractEvent interactEvent = (PlayerInteractEvent)event;
            if (!interactEvent.getItemStack().func_190926_b()) {
                // empty if block
            }
            if (isSameItem = this.matches(questStack, ((PlayerInteractEvent.RightClickItem)event).getItemStack())) {
                this.setInteracted(questStack, true);
                if (this.consumeItem) {
                    interactEvent.getItemStack().func_190918_g(1);
                }
                this.markComplete(questStack, entityPlayer);
                return new QuestLogicState(QuestState.Type.COMPLETE, true);
            }
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    public boolean hasInteracted(QuestStack questStack) {
        if (questStack.getTagCompound() != null) {
            return questStack.getTagCompound().func_74767_n("used");
        }
        return false;
    }

    public void setInteracted(QuestStack questStack, boolean readBook) {
        if (questStack.getTagCompound() == null) {
            questStack.setTagCompound(new NBTTagCompound());
        }
        questStack.getTagCompound().func_74757_a("used", readBook);
    }
}

