/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.QuestBlock;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.logic.AbstractQuestLogicBlock;
import matteroverdrive.util.MOJsonHelper;
import matteroverdrive.util.MOQuestHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicPlaceBlock
extends AbstractQuestLogicBlock {
    String namePattern;
    int minBlockPlace;
    int maxBlockPlace;
    private int radius;

    public QuestLogicPlaceBlock() {
    }

    public QuestLogicPlaceBlock(int radius, QuestItem blockStack) {
        this(radius, blockStack, 1, 1);
    }

    public QuestLogicPlaceBlock(int radius, QuestItem blockStack, int minBlockPlace, int maxBlockPlace) {
        super(blockStack);
        this.radius = radius;
        this.minBlockPlace = minBlockPlace;
        this.maxBlockPlace = maxBlockPlace;
    }

    public QuestLogicPlaceBlock(int radius, QuestBlock block) {
        this(radius, block, 1, 1);
    }

    public QuestLogicPlaceBlock(int radius, QuestBlock block, int minBlockPlace, int maxBlockPlace) {
        super(block);
        this.radius = radius;
        this.minBlockPlace = minBlockPlace;
        this.maxBlockPlace = maxBlockPlace;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        this.radius = MOJsonHelper.getInt(jsonObject, "radius", 0);
        this.minBlockPlace = MOJsonHelper.getInt(jsonObject, "place_count_min");
        this.maxBlockPlace = MOJsonHelper.getInt(jsonObject, "place_count_max");
        this.namePattern = MOJsonHelper.getString(jsonObject, "regex", null);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.getBlockPlaced(questStack) >= this.getMaxBlockPlace(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = this.replaceBlockNameInText(objective);
        BlockPos pos = MOQuestHelper.getPosition(questStack);
        if (pos != null) {
            double distance = new Vec3d(Math.floor(entityPlayer.field_70165_t), Math.floor(entityPlayer.field_70163_u), Math.floor(entityPlayer.field_70161_v)).func_72438_d(new Vec3d((Vec3i)pos));
            objective = objective.replace("$distance", Integer.toString((int)Math.max(distance - (double)this.radius, 0.0)) + " blocks");
        } else {
            objective = objective.replace("$distance", "0 blocks");
        }
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
        this.setMaxBlockPlace(questStack, this.random(random, this.minBlockPlace, this.maxBlockPlace));
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof BlockEvent.PlaceEvent) {
            BlockEvent.PlaceEvent placeEvent = (BlockEvent.PlaceEvent)event;
            boolean isTheSameBlockFlag = false;
            if (this.blockStack != null && !placeEvent.getItemInHand().func_190926_b()) {
                isTheSameBlockFlag = this.areBlockStackTheSame(placeEvent.getItemInHand());
            } else if (this.areBlocksTheSame(placeEvent.getPlacedBlock())) {
                isTheSameBlockFlag = this.namePattern != null && !placeEvent.getItemInHand().func_190926_b() ? placeEvent.getItemInHand().func_82833_r().matches(this.namePattern) : true;
            }
            BlockPos pos = MOQuestHelper.getPosition(questStack);
            if (pos != null && isTheSameBlockFlag && !(new Vec3d((Vec3i)placeEvent.getPos()).func_72438_d(new Vec3d((Vec3i)pos)) <= (double)this.radius)) {
                return null;
            }
            if (isTheSameBlockFlag) {
                this.setBlockPlaced(questStack, this.getBlockPlaced(questStack) + 1);
                this.markComplete(questStack, entityPlayer);
                return new QuestLogicState(QuestState.Type.COMPLETE, true);
            }
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    protected void setBlockPlaced(QuestStack questStack, int placed) {
        this.initTag(questStack);
        this.getTag(questStack).func_74777_a("Placed", (short)placed);
    }

    protected int getBlockPlaced(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("Placed");
        }
        return 0;
    }

    protected void setMaxBlockPlace(QuestStack questStack, int maxBlockPlace) {
        this.initTag(questStack);
        this.getTag(questStack).func_74777_a("MaxPlaced", (short)maxBlockPlace);
    }

    protected int getMaxBlockPlace(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74765_d("MaxPlaced");
        }
        return 0;
    }

    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }
}

