/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.recipes;

import com.google.common.collect.ImmutableList;
import java.util.List;
import matteroverdrive.data.recipes.Recipe;
import matteroverdrive.tile.TileEntityInscriber;
import net.minecraft.item.ItemStack;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InscriberRecipe
extends Recipe<TileEntityInscriber> {
    private ItemStack main;
    private ItemStack sec;
    private ItemStack output;
    private int energy;
    private int time;

    public ItemStack getMain() {
        return this.main;
    }

    public ItemStack getSec() {
        return this.sec;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getTime() {
        return this.time;
    }

    @Override
    public boolean matches(TileEntityInscriber machine) {
        ItemStack primary = machine.func_70301_a(TileEntityInscriber.MAIN_INPUT_SLOT_ID);
        ItemStack secondary = machine.func_70301_a(TileEntityInscriber.SEC_INPUT_SLOT_ID);
        return ItemStack.func_179545_c((ItemStack)primary, (ItemStack)this.main) && ItemStack.func_179545_c((ItemStack)secondary, (ItemStack)this.sec);
    }

    @Override
    public ItemStack getOutput(TileEntityInscriber machine) {
        return this.output.func_77946_l();
    }

    @Override
    public List<ItemStack> getInputs() {
        return ImmutableList.of((Object)this.main, (Object)this.sec);
    }

    @Override
    public void fromXML(Element element) {
        this.energy = InscriberRecipe.getIntAttr(element, "energy");
        this.time = InscriberRecipe.getIntAttr(element, "time");
        NodeList nodes = element.getChildNodes();
        block10: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            switch (node.getNodeName()) {
                case "primary": {
                    this.main = InscriberRecipe.getStack((Element)node);
                    continue block10;
                }
                case "secondary": {
                    this.sec = InscriberRecipe.getStack((Element)node);
                    continue block10;
                }
                case "output": {
                    this.output = InscriberRecipe.getStack((Element)node);
                }
            }
        }
    }
}

