/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.transport;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.util.MOLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ConnectionPathfind<T extends IGridNode> {
    private final Set<T> burned = new HashSet<T>();
    private final T target;
    private Class<T> nodeTypes;
    private TileEntity neighborTileTmp;
    private T neighborTmp;
    private IBlockState neighborTmpState;
    private BlockPos neighborPosTmp;

    public ConnectionPathfind(T target, Class<T> nodeTypes) {
        this.target = target;
        this.nodeTypes = nodeTypes;
    }

    public boolean init(T startNode) {
        this.burned.clear();
        this.burned.add(startNode);
        for (EnumFacing d : EnumFacing.field_82609_l) {
            if (!startNode.canConnectFromSide(startNode.getNodeWorld().func_180495_p(startNode.getNodePos()), d)) continue;
            BlockPos neighborPos = startNode.getNodePos().func_177972_a(d);
            TileEntity neighborTile = startNode.getNodeWorld().func_175625_s(neighborPos);
            if (!(neighborTile instanceof IGridNode) || neighborTile == this.target || !this.isConnectedToSourceRecursive((IGridNode)neighborTile)) continue;
            return true;
        }
        return false;
    }

    private boolean isConnectedToSourceRecursive(T node) {
        this.burned.add(node);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!node.canConnectFromSide(node.getNodeWorld().func_180495_p(node.getNodePos()), dir)) continue;
            this.neighborPosTmp = node.getNodePos().func_177972_a(dir);
            if (!node.getNodeWorld().func_175667_e(this.neighborPosTmp)) continue;
            this.neighborTileTmp = node.getNodeWorld().func_175625_s(this.neighborPosTmp);
            if (!this.nodeTypes.isInstance(this.neighborTileTmp)) continue;
            this.neighborTmp = (IGridNode)this.nodeTypes.cast(this.neighborTileTmp);
            this.neighborTmpState = this.neighborTmp.getNodeWorld().func_180495_p(this.neighborPosTmp);
            if (this.neighborTmp != this.target && this.burned.contains(this.neighborTmp)) continue;
            if (node.canConnectToNetworkNode(node.getNodeWorld().func_180495_p(node.getNodePos()), (IGridNode)this.neighborTmp, dir) && this.neighborTmp.canConnectToNetworkNode(this.neighborTmpState, (IGridNode)node, dir.func_176734_d())) {
                if (this.neighborTmp == this.target) {
                    return true;
                }
                if (!this.isConnectedToSourceRecursive(this.neighborTmp)) continue;
                return true;
            }
            MOLog.info("Matter Network Pathfind: cannot connect to node", new Object[0]);
        }
        return false;
    }

    public Collection<T> getBurnedNodes() {
        return this.burned;
    }
}

