/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.api.dialog.IDialogQuestGiver;
import matteroverdrive.api.dialog.IDialogRegistry;
import matteroverdrive.api.events.MOEventDialogConstruct;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.client.render.conversation.DialogShot;
import matteroverdrive.data.dialog.DialogMessage;
import matteroverdrive.data.dialog.DialogMessageAndroidOnly;
import matteroverdrive.data.dialog.DialogMessageBackToMain;
import matteroverdrive.data.dialog.DialogMessageQuestGive;
import matteroverdrive.data.dialog.DialogMessageQuestOnObjectivesCompleted;
import matteroverdrive.data.dialog.DialogMessageQuestStart;
import matteroverdrive.data.dialog.DialogMessageQuit;
import matteroverdrive.entity.monster.EntityMutantScientist;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.entity.tasks.EntityAITalkToPlayer;
import matteroverdrive.entity.tasks.EntityAIWatchDialogPlayer;
import matteroverdrive.init.MatterOverdriveDialogs;
import matteroverdrive.init.MatterOverdriveEntities;
import matteroverdrive.init.MatterOverdriveQuests;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.network.packet.server.PacketManageConversation;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class EntityVillagerMadScientist
extends EntityVillager
implements IDialogNpc,
IDialogQuestGiver {
    private static final DataParameter<Boolean> VARIANT = EntityDataManager.func_187226_a(EntityVillagerMadScientist.class, (DataSerializer)DataSerializers.field_187198_h);
    public static DialogMessage cocktailOfAscensionComplete;
    private static DialogMessage convertMe;
    private static DialogMessage canYouConvert;
    private static DialogMessage whatDidYouDo;
    private static DialogMessage cocktailOfAscension;
    private EntityPlayer dialogPlayer;
    private IDialogMessage startMessage;

    public EntityVillagerMadScientist(World world) {
        super(world, VillagerRegistry.getId((VillagerRegistry.VillagerProfession)MatterOverdriveEntities.MAD_SCIENTIST_PROFESSION));
        this.setProfession(MatterOverdriveEntities.MAD_SCIENTIST_PROFESSION);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITalkToPlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchDialogPlayer(this));
    }

    public static void registerDialogMessages(IDialogRegistry registry, Side side) {
        convertMe = new DialogMessageQuestOnObjectivesCompleted(null, "dialog.mad_scientist.convert.question", new QuestStack(MatterOverdriveQuests.punyHumans), new int[]{0}).setUnlocalized(true);
        registry.registerMessage(convertMe);
        canYouConvert = new DialogMessageQuestGive("dialog.mad_scientist.requirements.line", "dialog.mad_scientist.requirements.question", new QuestStack(MatterOverdriveQuests.punyHumans));
        registry.registerMessage(canYouConvert);
        canYouConvert.addOption(convertMe);
        canYouConvert.addOption(MatterOverdriveDialogs.backHomeMessage);
        canYouConvert.setUnlocalized(true);
        DialogMessage undo = new DialogMessage("dialog.mad_scientist.undo.line", "dialog.mad_scientist.undo.question");
        registry.registerMessage(undo);
        undo.setUnlocalized(true);
        undo.addOption(MatterOverdriveDialogs.trade);
        undo.addOption(MatterOverdriveDialogs.backHomeMessage);
        whatDidYouDo = new DialogMessageAndroidOnly("dialog.mad_scientist.whatDidYouDo.line", "dialog.mad_scientist.whatDidYouDo.question");
        registry.registerMessage(whatDidYouDo);
        whatDidYouDo.setUnlocalized(true);
        whatDidYouDo.addOption(undo);
        whatDidYouDo.addOption(MatterOverdriveDialogs.backHomeMessage);
        DialogMessage acceptCocktail = new DialogMessageQuestGive(null, "dialog.mad_scientist.junkie.cocktail_quest.question.accept", new QuestStack(MatterOverdriveQuests.cocktailOfAscension)).setReturnToMain(true).setUnlocalized(true);
        registry.registerMessage(acceptCocktail);
        DialogMessage declineCocktail = new DialogMessageBackToMain(null, "dialog.mad_scientist.junkie.cocktail_quest.question.decline").setUnlocalized(true);
        registry.registerMessage(declineCocktail);
        DialogMessage[] cocktailQuest = MatterOverdrive.DIALOG_FACTORY.constructMultipleLineDialog(DialogMessageQuestStart.class, "dialog.mad_scientist.junkie.cocktail_quest", 8, ". . . . . .");
        ((DialogMessageQuestStart)cocktailQuest[0]).setQuest(new QuestStack(MatterOverdriveQuests.cocktailOfAscension));
        cocktailOfAscension = cocktailQuest[0];
        DialogMessage lastLine = cocktailQuest[cocktailQuest.length - 1];
        lastLine.addOption(acceptCocktail);
        lastLine.addOption(declineCocktail);
        cocktailOfAscensionComplete = new DialogMessageQuestOnObjectivesCompleted("dialog.mad_scientist.junkie.cocktail_quest.line", "dialog.mad_scientist.junkie.cocktail_quest.complete.question", new QuestStack(MatterOverdriveQuests.cocktailOfAscension), new int[]{0, 1, 2}).setUnlocalized(true);
        DialogMessage areYouOk = new DialogMessageQuit(null, "dialog.mad_scientist.junkie.cocktail_quest.are_you_ok.question").setUnlocalized(true);
        cocktailOfAscensionComplete.addOption(areYouOk);
        if (side == Side.CLIENT) {
            canYouConvert.setShots(DialogShot.closeUp);
            undo.setShots(DialogShot.closeUp);
            whatDidYouDo.setShots(DialogShot.fromBehindLeftClose);
            for (DialogMessage aCocktailQuest : cocktailQuest) {
                MatterOverdrive.DIALOG_FACTORY.addRandomShots(aCocktailQuest);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)false);
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("junkie", this.getJunkie());
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setJunkie(nbtTagCompound.func_74767_n("junkie"));
    }

    public EntityVillager func_90011_a(EntityAgeable entity) {
        EntityVillagerMadScientist villager = new EntityVillagerMadScientist(this.field_70170_p);
        villager.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
        return villager;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            MatterOverdrive.NETWORK.sendToServer(new PacketManageConversation(this, true));
            return true;
        }
        return false;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        this.setJunkie(this.field_70146_Z.nextBoolean());
        return livingdata;
    }

    @Override
    public IDialogMessage getStartDialogMessage(EntityPlayer player) {
        return this.startMessage;
    }

    private IDialogMessage assembleStartingMessage(EntityPlayer player) {
        if (this.getJunkie()) {
            DialogMessage mainJunkieMessage = new DialogMessage(MOStringHelper.formatVariations("dialog.mad_scientist.junkie.main", "line", 2), null).setUnlocalized(true);
            MatterOverdrive.DIALOG_FACTORY.addOnlyVisibleOptions(player, this, mainJunkieMessage, canYouConvert, MatterOverdriveDialogs.trade, cocktailOfAscension, cocktailOfAscensionComplete, MatterOverdriveDialogs.quitMessage);
            return mainJunkieMessage;
        }
        if (MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player).isAndroid()) {
            DialogMessage mainAndroidMessage = new DialogMessage(MOStringHelper.formatVariations("dialog.mad_scientist.main.line", "android", 3), null);
            mainAndroidMessage.setUnlocalized(true);
            mainAndroidMessage.addOption(whatDidYouDo);
            mainAndroidMessage.addOption(MatterOverdriveDialogs.trade);
            mainAndroidMessage.addOption(MatterOverdriveDialogs.quitMessage);
            return mainAndroidMessage;
        }
        DialogMessage mainHumanMessage = new DialogMessage(MOStringHelper.formatVariations("dialog.mad_scientist.main.line", "human", 3), null);
        mainHumanMessage.setUnlocalized(true);
        mainHumanMessage.addOption(canYouConvert);
        mainHumanMessage.addOption(MatterOverdriveDialogs.quitMessage);
        return mainHumanMessage;
    }

    @Override
    public EntityPlayer getDialogPlayer() {
        return this.dialogPlayer;
    }

    @Override
    public void setDialogPlayer(EntityPlayer player) {
        this.dialogPlayer = player;
        if (player != null) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventDialogConstruct.Pre(this, player, this.startMessage))) {
                this.startMessage = this.assembleStartingMessage(player);
                MinecraftForge.EVENT_BUS.post((Event)new MOEventDialogConstruct.Post(this, player, this.startMessage));
            }
        } else {
            this.startMessage = null;
        }
    }

    @Override
    public boolean canTalkTo(EntityPlayer player) {
        return MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player) == null || !MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player).isTurning();
    }

    @Override
    public EntityLiving getEntity() {
        return this;
    }

    @Override
    public void onPlayerInteract(EntityPlayer player, DialogMessage dialogMessage) {
        if (dialogMessage == cocktailOfAscensionComplete) {
            this.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"wither"), 1000, 1));
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, MatterOverdriveSounds.failedAnimalDie, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            this.func_70106_y();
            EntityMutantScientist mutantScientist = new EntityMutantScientist(this.field_70170_p);
            mutantScientist.func_70656_aK();
            mutantScientist.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            mutantScientist.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
            this.field_70170_p.func_72838_d((Entity)mutantScientist);
        } else if (dialogMessage == convertMe) {
            OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)player);
            for (QuestStack questStack : extendedProperties.getQuestData().getActiveQuests()) {
                if (questStack.getQuest() != MatterOverdriveQuests.punyHumans) continue;
                questStack.markComplited(player, false);
                MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player).startConversion();
            }
        }
    }

    @Override
    public void giveQuest(IDialogMessage message, QuestStack questStack, EntityPlayer entityPlayer) {
        OverdriveExtendedProperties extendedProperties;
        if (questStack != null && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)entityPlayer)) != null && questStack.getQuest().canBeAccepted(questStack, entityPlayer)) {
            QuestStack newQuestStack = questStack.copy();
            newQuestStack.setGiver((Entity)this);
            extendedProperties.addQuest(newQuestStack);
        }
    }

    public boolean getJunkie() {
        return (Boolean)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setJunkie(boolean junkie) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)junkie);
        if (junkie) {
            this.func_96094_a(MOStringHelper.translateToLocal("entity.matteroverdrive.mad_scientist.junkie.name", new Object[0]));
        }
    }
}

