/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.ai;

import matteroverdrive.entity.ai.PathNavigateFly;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAIFollowCreator<T extends EntityLiving>
extends EntityAIBase {
    World world;
    float maxDist;
    float minDist;
    private T pet;
    private Entity theOwner;
    private double followSpeed;
    private PathNavigate petPathfinder;
    private int timeToRecalcPath;

    public EntityAIFollowCreator(T pet, double followSpeed, float minDist, float maxDist) {
        this.pet = pet;
        this.world = ((EntityLiving)pet).field_70170_p;
        this.followSpeed = followSpeed;
        this.petPathfinder = pet.func_70661_as();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.func_75248_a(3);
        if (!(pet.func_70661_as() instanceof PathNavigateFly)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        Entity entity = ((IEntityOwnable)this.pet).func_70902_q();
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
            return false;
        }
        if (this.pet.func_70068_e(entity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.theOwner = entity;
        return true;
    }

    public boolean continueExecuting() {
        return !this.petPathfinder.func_75500_f() && this.pet.func_70068_e(this.theOwner) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
    }

    public void func_75251_c() {
        this.theOwner = null;
        this.petPathfinder.func_75499_g();
    }

    private boolean func_181065_a(BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150350_a || !state.func_185917_h();
    }

    public void func_75246_d() {
        this.pet.func_70671_ap().func_75651_a(this.theOwner, 10.0f, (float)this.pet.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.petPathfinder.func_75492_a(this.theOwner.field_70165_t, this.theOwner.field_70163_u + (double)this.theOwner.func_70047_e(), this.theOwner.field_70161_v + 2.0, this.followSpeed) && !this.pet.func_110167_bD() && this.pet.func_70068_e(this.theOwner) >= 144.0) {
                int x = MathHelper.func_76128_c((double)this.theOwner.field_70165_t) - 1;
                int z = MathHelper.func_76128_c((double)this.theOwner.field_70161_v) - 1;
                int y = MathHelper.func_76128_c((double)this.theOwner.func_174813_aQ().field_72337_e);
                for (int xMov = 0; xMov <= 3; ++xMov) {
                    for (int zMov = 0; zMov <= 3; ++zMov) {
                        if (xMov >= 1 && zMov >= 1 && xMov <= 2 && zMov <= 2 || !this.func_181065_a(new BlockPos(x + xMov, y, z + zMov)) || !this.func_181065_a(new BlockPos(x + xMov, y + 1, z + zMov))) continue;
                        this.pet.func_70012_b((double)((float)(x + xMov) + 0.5f), (double)y, (double)((float)(z + zMov) + 0.5f), ((EntityLiving)this.pet).field_70177_z, ((EntityLiving)this.pet).field_70125_A);
                        this.petPathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }
}

