/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.monster;

import io.netty.buffer.ByteBuf;
import matteroverdrive.Reference;
import matteroverdrive.api.entity.IPathableMob;
import matteroverdrive.entity.monster.EntityRogueAndroid;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.tile.TileEntityAndroidSpawner;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityRougeAndroidMob
extends EntityMob
implements IEntityAdditionalSpawnData,
IPathableMob<EntityRougeAndroidMob> {
    private static final ResourceLocation androidNames = new ResourceLocation("matteroverdrive:info/android_names.txt");
    private static final String[] names = MOStringHelper.readTextFile(androidNames).split(",");
    boolean fromSpawner;
    private BlockPos spawnerPosition;
    private int currentPathIndex;
    private Vec3d[] path;
    private int maxPathTargetRangeSq;
    private int visorColor;
    private ScorePlayerTeam team;
    private boolean legendary;
    private int level;

    public EntityRougeAndroidMob(World world) {
        super(world);
        if (!world.field_72995_K) {
            this.setAndroidLevel((int)MathHelper.func_151237_a((double)Math.abs(this.field_70146_Z.nextGaussian() * (1.0 + (double)world.func_175659_aa().func_151525_a() * 0.25)), (double)0.0, (double)3.0));
            boolean isLegendary = this.field_70146_Z.nextDouble() < (double)(EntityRogueAndroid.LEGENDARY_SPAWN_CHANCE * (float)this.getAndroidLevel());
            this.setLegendary(isLegendary);
            this.init();
        }
    }

    public EntityRougeAndroidMob(World world, int level, boolean legendary) {
        super(world);
        this.setAndroidLevel(level);
        this.setLegendary(legendary);
        this.init();
    }

    private void init() {
        String name = this.getIsLegendary() ? String.format("%s %s ", "\u272a", MOStringHelper.translateToLocal("rarity.legendary", new Object[0])) : "";
        name = name + String.format("[%s] ", this.getAndroidLevel());
        name = name + names[this.field_70146_Z.nextInt(names.length)];
        this.func_96094_a(name);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getIsLegendary() ? 128.0 : (double)(this.getAndroidLevel() * 10 + 32));
        this.func_70606_j(this.func_110138_aP());
        if (this.fromSpawner && !this.addToSpawner(this.spawnerPosition)) {
            this.func_70106_y();
        }
        if (this.getIsLegendary()) {
            this.setVisorColor(Reference.COLOR_HOLO_RED.getColor());
        } else {
            switch (this.getAndroidLevel()) {
                case 0: {
                    this.setVisorColor(Reference.COLOR_HOLO.getColor());
                    break;
                }
                case 1: {
                    this.setVisorColor(Reference.COLOR_HOLO_YELLOW.getColor());
                    break;
                }
                case 2: {
                    this.setVisorColor(Reference.COLOR_HOLO_PURPLE.getColor());
                    break;
                }
                default: {
                    this.setVisorColor(-1);
                }
            }
        }
    }

    public TextFormatting getNameColor() {
        if (this.getIsLegendary()) {
            return TextFormatting.GOLD;
        }
        switch (this.getAndroidLevel()) {
            case 0: {
                return TextFormatting.GRAY;
            }
            case 1: {
                return TextFormatting.DARK_AQUA;
            }
            case 2: {
                return TextFormatting.DARK_PURPLE;
            }
        }
        return null;
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.setLegendary(nbtTagCompound.func_74767_n("Legendary"));
        this.setAndroidLevel(nbtTagCompound.func_74771_c("Level"));
        this.setVisorColor(nbtTagCompound.func_74762_e("VisorColor"));
        if (nbtTagCompound.func_150297_b("Team", 8)) {
            ScorePlayerTeam team = this.field_70170_p.func_96441_U().func_96508_e(nbtTagCompound.func_74779_i("Team"));
            if (team != null) {
                this.setTeam(team);
            } else {
                this.func_70106_y();
            }
        }
        if (nbtTagCompound.func_150297_b("SpawnerPos", 10)) {
            this.spawnerPosition = BlockPos.func_177969_a((long)nbtTagCompound.func_74763_f("SpawnerPos"));
            this.fromSpawner = true;
        }
        this.currentPathIndex = nbtTagCompound.func_74762_e("CurrentPathIndex");
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74774_a("Level", (byte)this.getAndroidLevel());
        nbtTagCompound.func_74757_a("Legendary", this.getIsLegendary());
        nbtTagCompound.func_74768_a("VisorColor", this.getVisorColor());
        if (this.getTeam() != null) {
            nbtTagCompound.func_74778_a("Team", this.getTeam().func_96661_b());
        }
        if (this.spawnerPosition != null) {
            nbtTagCompound.func_74772_a("SpawnerPos", this.spawnerPosition.func_177986_g());
        }
        nbtTagCompound.func_74768_a("CurrentPathIndex", this.currentPathIndex);
    }

    private boolean addToSpawner(BlockPos position) {
        this.spawnerPosition = position;
        TileEntity spawnerEntity = this.field_70170_p.func_175625_s(position);
        if (spawnerEntity != null && spawnerEntity instanceof TileEntityAndroidSpawner) {
            ((TileEntityAndroidSpawner)spawnerEntity).addSpawnedAndroid(this);
            return true;
        }
        return false;
    }

    public void func_70624_b(EntityLivingBase target) {
        if (target != null && target.func_96124_cp() != null) {
            if (!target.func_96124_cp().func_142054_a((Team)this.getTeam())) {
                super.func_70624_b(target);
            }
        } else {
            super.func_70624_b(target);
        }
    }

    public boolean func_70687_e(PotionEffect potion) {
        return false;
    }

    public boolean func_70601_bi() {
        return this.getCanSpawnHere(false, false, false) && !this.hasToManyAndroids() && this.field_70146_Z.nextFloat() < EntityRogueAndroid.SPAWN_CHANCE;
    }

    public boolean hasToManyAndroids() {
        Chunk chunk = this.field_70170_p.func_72964_e(this.field_70176_ah, this.field_70164_aj);
        int androidCount = 0;
        for (int i = 0; i < chunk.func_177429_s().length; ++i) {
            for (Entity entity : chunk.func_177429_s()[i]) {
                if (!(entity instanceof EntityRougeAndroidMob) || ++androidCount <= EntityRogueAndroid.MAX_ANDROIDS_PER_CHUNK) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getCanSpawnHere(boolean ignoreEntityCollision, boolean ignoreLight, boolean ignoreDimension) {
        if (!ignoreDimension) {
            if (EntityRogueAndroid.dimensionWhitelist.size() > 0) {
                return EntityRogueAndroid.dimensionWhitelist.contains(this.field_70170_p.field_73011_w.getDimension()) && this.inDimensionBlacklist();
            }
            if (this.inDimensionBlacklist()) {
                return false;
            }
        }
        boolean light = ignoreLight || this.func_70814_o();
        boolean entityCollison = ignoreEntityCollision || this.field_70170_p.func_72855_b(this.func_174813_aQ());
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && light && entityCollison && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    public float func_180484_a(BlockPos pos) {
        float weight = 1.0f - this.field_70170_p.func_175724_o(pos);
        weight *= this.field_70170_p.isSideSolid(pos, EnumFacing.UP) ? 0.0f : 1.0f;
        weight = (float)((double)weight / Math.abs((double)pos.func_177956_o() - this.field_70163_u));
        return weight;
    }

    protected void addRandomArmor() {
        if (this.field_70146_Z.nextFloat() < 0.15f) {
            float f;
            int i = this.field_70146_Z.nextInt(2);
            float f2 = f = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.1f : 0.25f;
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            if (this.field_70146_Z.nextFloat() < 0.095f) {
                ++i;
            }
            this.func_174820_d(100, ItemStack.field_190927_a);
            this.func_174820_d(101, ItemStack.field_190927_a);
            this.func_174820_d(102, ItemStack.field_190927_a);
            this.func_174820_d(103, ItemStack.field_190927_a);
        }
    }

    public boolean func_180485_d(BlockPos pos) {
        return true;
    }

    public boolean func_110175_bO() {
        return this.getCurrentTarget() != null;
    }

    public BlockPos func_180486_cf() {
        Vec3d currentTarget = this.getCurrentTarget();
        return new BlockPos((int)currentTarget.field_72450_a, (int)currentTarget.field_72448_b, (int)currentTarget.field_72449_c);
    }

    private boolean inDimensionBlacklist() {
        return EntityRogueAndroid.dimensionBlacklist.contains(this.field_70170_p.field_73011_w.getDimension());
    }

    public int getAndroidLevel() {
        return this.level;
    }

    public void setAndroidLevel(int level) {
        this.level = level;
    }

    public void setLegendary(boolean legendary) {
        this.legendary = legendary;
        this.field_70131_O = legendary ? 2.8799999f : 1.8f;
    }

    public boolean getIsLegendary() {
        return this.legendary;
    }

    public String func_95999_t() {
        if (this.hasTeam()) {
            return this.getTeam().func_142053_d(super.func_95999_t());
        }
        TextFormatting color = this.getNameColor();
        if (color != null) {
            return color + super.func_95999_t();
        }
        return super.func_95999_t();
    }

    public ScorePlayerTeam getTeam() {
        return this.team;
    }

    public void setTeam(ScorePlayerTeam team) {
        this.team = team;
    }

    public boolean hasTeam() {
        return this.getTeam() != null;
    }

    public boolean wasSpawnedFrom(TileEntityAndroidSpawner spawner) {
        if (this.spawnerPosition != null) {
            TileEntity tileEntity = this.field_70170_p.func_175625_s(this.spawnerPosition);
            return tileEntity == spawner;
        }
        return false;
    }

    public void setSpawnerPosition(BlockPos position) {
        this.spawnerPosition = position;
        this.fromSpawner = true;
    }

    public void func_70106_y() {
        TileEntity spawner;
        if (this.spawnerPosition != null && (spawner = this.field_70170_p.func_175625_s(this.spawnerPosition)) != null && spawner instanceof TileEntityAndroidSpawner) {
            ((TileEntityAndroidSpawner)spawner).removeAndroid(this);
        }
        this.field_70128_L = true;
    }

    public int getVisorColor() {
        return this.visorColor;
    }

    public void setVisorColor(int color) {
        this.visorColor = color;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.level);
        buffer.writeBoolean(this.legendary);
        buffer.writeInt(this.visorColor);
        buffer.writeBoolean(this.hasTeam());
        if (this.hasTeam()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.getTeam().func_96661_b());
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setAndroidLevel(additionalData.readByte());
        this.setLegendary(additionalData.readBoolean());
        this.setVisorColor(additionalData.readInt());
        if (additionalData.readBoolean()) {
            String teamName = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
            ScorePlayerTeam team = this.field_70170_p.func_96441_U().func_96508_e(teamName);
            if (team != null) {
                this.setTeam(team);
            }
        }
    }

    @Override
    public Vec3d getCurrentTarget() {
        if (this.path != null && this.currentPathIndex < this.path.length) {
            return this.path[this.currentPathIndex];
        }
        return null;
    }

    @Override
    public void onTargetReached(Vec3d pos) {
        if (this.currentPathIndex < this.path.length - 1) {
            ++this.currentPathIndex;
        }
    }

    @Override
    public boolean isNearTarget(Vec3d pos) {
        return pos.func_72436_e(pos) < (double)this.maxPathTargetRangeSq;
    }

    @Override
    public EntityRougeAndroidMob getEntity() {
        return this;
    }

    public void setPath(Vec3d[] path, int range) {
        this.path = path;
        this.maxPathTargetRangeSq = range * range;
    }

    protected SoundEvent func_184639_G() {
        return MatterOverdriveSounds.mobsRogueAndroidSay;
    }

    protected SoundEvent func_184615_bR() {
        return MatterOverdriveSounds.mobsRogueAndroidDeath;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    public int func_70627_aG() {
        return 480;
    }
}

