/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.player;

import java.util.EnumSet;
import matteroverdrive.api.android.IAndroid;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class MOPlayerCapabilityProvider
implements ICapabilitySerializable<NBTTagCompound> {
    AndroidPlayer androidPlayer;
    OverdriveExtendedProperties extendedProperties;

    public MOPlayerCapabilityProvider(EntityPlayer player) {
        this.androidPlayer = new AndroidPlayer(player);
        this.extendedProperties = new OverdriveExtendedProperties(player);
    }

    public static AndroidPlayer GetAndroidCapability(Entity entity) {
        if (entity == null) {
            return null;
        }
        return entity.hasCapability(AndroidPlayer.CAPABILITY, null) ? (AndroidPlayer)entity.getCapability(AndroidPlayer.CAPABILITY, null) : null;
    }

    public static OverdriveExtendedProperties GetExtendedCapability(Entity entity) {
        if (entity == null) {
            return null;
        }
        return (OverdriveExtendedProperties)entity.getCapability(OverdriveExtendedProperties.CAPIBILITY, EnumFacing.DOWN);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == AndroidPlayer.CAPABILITY || capability == OverdriveExtendedProperties.CAPIBILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == AndroidPlayer.CAPABILITY) {
            return (T)this.androidPlayer;
        }
        if (capability == OverdriveExtendedProperties.CAPIBILITY) {
            return (T)this.extendedProperties;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagCompound androidTag = new NBTTagCompound();
        this.androidPlayer.writeToNBT(androidTag, EnumSet.allOf(IAndroid.DataType.class));
        tagCompound.func_74782_a("Android", (NBTBase)androidTag);
        this.extendedProperties.saveNBTData(tagCompound);
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.extendedProperties.loadNBTData(nbt);
        NBTTagCompound androidNbt = nbt.func_74775_l("Android");
        this.androidPlayer.readFromNBT(androidNbt, EnumSet.allOf(IAndroid.DataType.class));
    }
}

