/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.weapon;

import io.netty.buffer.ByteBuf;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.weapon.MOEventPlasmaBlotHit;
import matteroverdrive.api.gravity.IGravitationalAnomaly;
import matteroverdrive.api.gravity.IGravityEntity;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.fx.EntityFXGenericAnimatedParticle;
import matteroverdrive.fx.PhaserBoltRecoil;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.client.PacketUpdatePlasmaBolt;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlasmaBolt
extends Entity
implements IProjectile,
IGravityEntity,
IEntityAdditionalSpawnData {
    public Entity shootingEntity;
    private BlockPos blockPos;
    private int distanceTraveled;
    private float damage;
    private IBlockState blockState;
    private int life;
    private int color;
    private float fireDamageMultiply;
    private ItemStack weapon;
    private float renderSize = 2.0f;
    private boolean canHurtCaster = false;
    private float knockback;
    private boolean canRicoche;
    private float explodeMultiply;

    public PlasmaBolt(World world) {
        super(world);
        PlasmaBolt.func_184227_b((double)3.0);
        this.func_70105_a(0.5f, 0.5f);
    }

    public PlasmaBolt(World world, EntityLivingBase entityLivingBase, Vec3d position, Vec3d dir, WeaponShot shot, float speed) {
        super(world);
        this.field_70146_Z.setSeed(shot.getSeed());
        this.func_145769_d(shot.getSeed());
        this.shootingEntity = entityLivingBase;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, entityLivingBase.field_70177_z, entityLivingBase.field_70125_A);
        this.field_70159_w = dir.field_72450_a;
        this.field_70181_x = dir.field_72448_b;
        this.field_70179_y = dir.field_72449_c;
        this.field_70131_O = 0.0f;
        this.life = shot.getRange();
        this.damage = shot.getDamage();
        this.color = shot.getColor();
        this.blockPos = new BlockPos(0, 0, 0);
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, speed * 1.5f, shot.getAccuracy());
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
    }

    public void setThrowableHeading(double x, double y, double z, float speed, float accuracy) {
        float dirLength = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)dirLength;
        y /= (double)dirLength;
        z /= (double)dirLength;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)accuracy;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
    }

    protected void func_70088_a() {
    }

    public void simulateDelay(int delay) {
        if (delay > 0) {
            double lastMotionX = this.field_70159_w;
            double lastMotionY = this.field_70181_x;
            double lastMotionZ = this.field_70179_y;
            this.field_70159_w *= (double)delay;
            this.field_70181_x *= (double)delay;
            this.field_70179_y *= (double)delay;
            this.func_70071_h_();
            this.field_70159_w = lastMotionX;
            this.field_70181_x = lastMotionY;
            this.field_70179_y = lastMotionZ;
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        IBlockState blockState;
        if (!this.field_70170_p.field_72995_K && this.shootingEntity instanceof EntityPlayerMP) {
            MatterOverdrive.NETWORK.sendTo(new PacketUpdatePlasmaBolt(this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v), (EntityPlayerMP)this.shootingEntity);
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((blockState = this.field_70170_p.func_180495_p(this.blockPos)).func_185904_a() != Material.field_151579_a && (axisalignedbb = blockState.func_185890_d((IBlockAccess)this.field_70170_p, this.blockPos)) != null && axisalignedbb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.func_70106_y();
        }
        if (this.distanceTraveled > this.life) {
            this.func_70106_y();
            return;
        }
        this.distanceTraveled = (int)((double)this.distanceTraveled + new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72433_c());
        float motionLeway = 0.0f;
        Vec3d vec31 = new Vec3d(this.field_70165_t - this.field_70159_w * (double)motionLeway, this.field_70163_u - this.field_70181_x * (double)motionLeway, this.field_70161_v - this.field_70179_y * (double)motionLeway);
        Vec3d vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
        vec31 = new Vec3d(this.field_70165_t - this.field_70159_w * (double)motionLeway, this.field_70163_u - this.field_70181_x * (double)motionLeway, this.field_70161_v - this.field_70179_y * (double)motionLeway);
        vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec3 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        Vec3d hit = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb1;
            RayTraceResult movingobjectposition1;
            if (entity1 == null || !entity1.func_70075_an() || entity1.field_70128_L || !(entity1 instanceof EntityLivingBase) || ((EntityLivingBase)entity1).field_70725_aQ != 0) continue;
            float f1 = 0.3f;
            if (this.shootingEntity != null && (this.shootingEntity instanceof EntityLivingBase && !this.canAttackTeammate((EntityLivingBase)entity1, (EntityLivingBase)this.shootingEntity) || !this.canHurtCaster && (entity1 == this.shootingEntity || entity1 == this.shootingEntity.func_184187_bx())) || (movingobjectposition1 = (axisalignedbb1 = entity1.func_174813_aQ().func_72321_a((double)f1, (double)f1, (double)f1)).func_72327_a(vec31, vec3)) == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            hit = movingobjectposition1.field_72307_f;
            d0 = d1;
        }
        if (entity != null) {
            movingobjectposition = new RayTraceResult(entity, hit);
        }
        if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
            if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                movingobjectposition = null;
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72308_g != null) {
                DamageSource damagesource = this.shootingEntity == null ? this.getDamageSource(this) : this.getDamageSource(this.shootingEntity);
                movingobjectposition.field_72308_g.field_70172_ad = 0;
                double lastMotionX = movingobjectposition.field_72308_g.field_70159_w;
                double lastMotionY = movingobjectposition.field_72308_g.field_70181_x;
                double lastMotionZ = movingobjectposition.field_72308_g.field_70179_y;
                boolean attack = movingobjectposition.field_72308_g.func_70097_a(damagesource, this.damage);
                if (!attack && movingobjectposition.field_72308_g instanceof EntityDragon) {
                    attack = ((EntityDragon)movingobjectposition.field_72308_g).func_70965_a(((EntityDragon)movingobjectposition.field_72308_g).field_70987_i, damagesource, this.damage);
                }
                if (attack) {
                    movingobjectposition.field_72308_g.field_70159_w = lastMotionX + (movingobjectposition.field_72308_g.field_70159_w - lastMotionX) * (double)this.knockback;
                    movingobjectposition.field_72308_g.field_70181_x = lastMotionY + (movingobjectposition.field_72308_g.field_70181_x - lastMotionY) * (double)this.knockback;
                    movingobjectposition.field_72308_g.field_70179_y = lastMotionZ + (movingobjectposition.field_72308_g.field_70179_y - lastMotionZ) * (double)this.knockback;
                    if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                        EntityLivingBase entitylivingbase = (EntityLivingBase)movingobjectposition.field_72308_g;
                        if (this.shootingEntity != null && this.shootingEntity instanceof EntityLivingBase) {
                            EnchantmentHelper.func_151385_b((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                            EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                        }
                        if (this.shootingEntity != null && movingobjectposition.field_72308_g != this.shootingEntity && movingobjectposition.field_72308_g instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                        }
                    }
                    if (this.fireDamageMultiply > 0.0f) {
                        movingobjectposition.field_72308_g.func_70015_d((int)(10.0f * this.fireDamageMultiply));
                    }
                    if (!(movingobjectposition.field_72308_g instanceof EntityEnderman)) {
                        this.func_70106_y();
                    }
                } else if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                    this.func_70106_y();
                }
                if (this.field_70170_p.field_72995_K) {
                    if (this.weapon != null && this.weapon.func_77973_b() instanceof EnergyWeapon) {
                        ((EnergyWeapon)this.weapon.func_77973_b()).onProjectileHit(movingobjectposition, this.weapon, this.field_70170_p, 5.0f);
                    }
                    this.onHit(movingobjectposition);
                }
                this.manageExplosions(movingobjectposition);
                MinecraftForge.EVENT_BUS.post((Event)new MOEventPlasmaBlotHit(this.weapon, movingobjectposition, this, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER));
            } else {
                this.blockPos = movingobjectposition.func_178782_a();
                this.blockState = this.field_70170_p.func_180495_p(this.blockPos);
                if (this.blockState.func_185904_a() != Material.field_151579_a) {
                    this.blockState.func_177230_c().func_180634_a(this.field_70170_p, this.blockPos, this.blockState, (Entity)this);
                    if (this.blockState instanceof BlockTNT) {
                        this.field_70170_p.func_175698_g(this.blockPos);
                        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(this.field_70170_p, (double)((float)this.blockPos.func_177958_n() + 0.5f), (double)((float)this.blockPos.func_177956_o() + 0.5f), (double)((float)this.blockPos.func_177952_p() + 0.5f), this.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)this.shootingEntity : null);
                        entitytntprimed.func_184534_a(0);
                        this.field_70170_p.func_72838_d((Entity)entitytntprimed);
                    }
                }
                if (this.field_70170_p.field_72995_K) {
                    if (this.weapon != null && this.weapon.func_77973_b() instanceof EnergyWeapon) {
                        ((EnergyWeapon)this.weapon.func_77973_b()).onProjectileHit(movingobjectposition, this.weapon, this.field_70170_p, 5.0f);
                    }
                    this.onHit(movingobjectposition);
                }
                MinecraftForge.EVENT_BUS.post((Event)new MOEventPlasmaBlotHit(this.weapon, movingobjectposition, this, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER));
                if (!this.manageExplosions(movingobjectposition)) {
                    if (this.canRicoche) {
                        this.handleRicochets(movingobjectposition);
                    } else {
                        this.func_70106_y();
                    }
                } else {
                    this.func_70106_y();
                }
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI), (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI));
        this.func_145775_I();
        super.func_70071_h_();
    }

    protected void handleRicochets(RayTraceResult hit) {
        Vec3d motion = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        Vec3d surfaceNormal = new Vec3d(hit.field_178784_b.func_176730_m());
        double deflectDot = surfaceNormal.func_72430_b(motion) * 2.0;
        Vec3d projection = new Vec3d(surfaceNormal.field_72450_a * deflectDot, surfaceNormal.field_72448_b * deflectDot, surfaceNormal.field_72449_c * deflectDot);
        Vec3d deflectDir = motion.func_178788_d(projection);
        this.field_70159_w = deflectDir.field_72450_a;
        this.field_70181_x = deflectDir.field_72448_b;
        this.field_70179_y = deflectDir.field_72449_c;
        this.distanceTraveled += 2;
        this.canHurtCaster = true;
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            ((ClientWeaponHandler)MatterOverdrive.PROXY.getWeaponHandler()).removePlasmaBolt(this);
        }
        super.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    protected void onHit(RayTraceResult hit) {
        Vec3d sideHit = hit.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK) ? new Vec3d(hit.field_178784_b.func_176730_m()) : new Vec3d(-this.field_70159_w, -this.field_70181_x, -this.field_70179_y);
        Color c = new Color(this.color);
        if (hit.field_72313_a.equals((Object)RayTraceResult.Type.ENTITY)) {
            if (hit.field_72308_g instanceof EntityLivingBase) {
                EntityFXGenericAnimatedParticle blood = new EntityFXGenericAnimatedParticle(this.field_70170_p, hit.field_72307_f.field_72450_a + this.field_70146_Z.nextDouble() * 0.4 - 0.2, hit.field_72307_f.field_72448_b + this.field_70146_Z.nextDouble() * 0.4 - 0.2, hit.field_72307_f.field_72449_c + this.field_70146_Z.nextDouble() * 0.4 - 0.2, 6.0f + this.field_70146_Z.nextFloat() * 2.0f, RenderParticlesHandler.blood);
                blood.setParticleMaxAge(12);
                blood.setRenderDistanceWeight(3.0f);
                ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(blood, RenderParticlesHandler.Blending.Transparent);
            }
        } else {
            int hitPraticles = Math.max(0, (int)(16.0f * this.renderSize) - (int)(8.0f * this.renderSize) * Minecraft.func_71410_x().field_71474_y.field_74362_aa);
            for (int i = 0; i < hitPraticles; ++i) {
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new PhaserBoltRecoil(this.field_70170_p, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, c, sideHit.field_72450_a * 30.0, sideHit.field_72448_b * 30.0, sideHit.field_72449_c * 30.0));
            }
            if ((double)this.getRenderSize() > 0.5) {
                MOPositionedSound sizzleSound = new MOPositionedSound(MatterOverdriveSounds.weaponsSizzle, SoundCategory.PLAYERS, this.field_70146_Z.nextFloat() * 0.2f + 0.4f, this.field_70146_Z.nextFloat() * 0.6f + 0.7f);
                sizzleSound.setPosition((float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sizzleSound);
                if (hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                    MOPositionedSound ricochetSound = new MOPositionedSound(MatterOverdriveSounds.weaponsLaserRicochet, SoundCategory.PLAYERS, this.field_70146_Z.nextFloat() * 0.2f + 0.6f, this.field_70146_Z.nextFloat() * 0.2f + 1.0f);
                    ricochetSound.setPosition((float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)ricochetSound);
                }
            }
            if (this.field_70146_Z.nextBoolean()) {
                EntityFXGenericAnimatedParticle smoke = new EntityFXGenericAnimatedParticle(this.field_70170_p, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 8.0f + this.field_70146_Z.nextFloat() * 2.0f, RenderParticlesHandler.smoke);
                smoke.setParticleMaxAge(20);
                smoke.setRenderDistanceWeight(2.0f);
                smoke.setColorRGBA(c.multiply(1.0f, 1.0f, 1.0f, 0.5f));
                smoke.setBottomPivot(true);
                ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(smoke, RenderParticlesHandler.Blending.Transparent);
            }
        }
    }

    private boolean manageExplosions(RayTraceResult hit) {
        if (this.explodeMultiply > 0.0f) {
            if (!this.field_70170_p.field_72995_K) {
                Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, this.explodeMultiply, false, false);
                if (!ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
                    explosion.func_77278_a();
                    this.field_70170_p.func_184148_a(null, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, MatterOverdriveSounds.weaponsExplosiveShot, SoundCategory.PLAYERS, 3.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                }
            } else {
                this.manageClientExplosions(hit);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void manageClientExplosions(RayTraceResult hit) {
        float explosionRange = this.explodeMultiply * 0.2f;
        EntityFXGenericAnimatedParticle explosion = new EntityFXGenericAnimatedParticle(this.field_70170_p, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, 10.0f, RenderParticlesHandler.explosion);
        explosion.setRenderDistanceWeight(3.0f);
        explosion.setParticleMaxAge(18);
        ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(explosion, RenderParticlesHandler.Blending.Transparent);
        for (int i = 0; i < 6; ++i) {
            explosion = new EntityFXGenericAnimatedParticle(this.field_70170_p, hit.field_72307_f.field_72450_a + this.field_70146_Z.nextGaussian() * (double)explosionRange, hit.field_72307_f.field_72448_b + this.field_70146_Z.nextGaussian() * (double)explosionRange, hit.field_72307_f.field_72449_c + this.field_70146_Z.nextGaussian() * (double)explosionRange, 4.0f + this.field_70146_Z.nextFloat() * 4.0f, RenderParticlesHandler.explosion);
            explosion.setRenderDistanceWeight(3.0f);
            explosion.setParticleMaxAge(18);
            ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(explosion, RenderParticlesHandler.Blending.Transparent);
        }
    }

    private boolean canAttackTeammate(EntityLivingBase shooter, EntityLivingBase target) {
        if (shooter != null && target != null) {
            if (shooter.func_96124_cp() != null && shooter.func_184191_r((Entity)target)) {
                return shooter.func_96124_cp().func_96665_g();
            }
            return true;
        }
        return true;
    }

    public DamageSource getDamageSource(Entity shootingEntity) {
        EntityDamageSourceIndirect dmg = new EntityDamageSourceIndirect("plasmaBolt", (Entity)this, shootingEntity);
        dmg.func_76349_b();
        return dmg;
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.blockPos.func_177958_n());
        tagCompound.func_74777_a("yTile", (short)this.blockPos.func_177956_o());
        tagCompound.func_74777_a("zTile", (short)this.blockPos.func_177952_p());
        tagCompound.func_74776_a("damage", this.damage);
        tagCompound.func_74768_a("distanceTraveled", this.distanceTraveled);
        tagCompound.func_74768_a("life", this.life);
        tagCompound.func_74768_a("color", this.color);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.blockPos = new BlockPos((int)tagCompound.func_74765_d("xTile"), (int)tagCompound.func_74765_d("yTile"), (int)tagCompound.func_74765_d("zTile"));
        if (tagCompound.func_150297_b("damage", 99)) {
            this.damage = tagCompound.func_74760_g("damage");
        }
        if (tagCompound.func_150297_b("ticksInAir", 99)) {
            this.distanceTraveled = tagCompound.func_74762_e("distanceTraveled");
        }
        if (tagCompound.func_150297_b("life", 99)) {
            this.life = tagCompound.func_74762_e("life");
        }
        if (tagCompound.func_150297_b("color", 99)) {
            this.color = tagCompound.func_74762_e("color");
        }
    }

    public void func_70100_b_(EntityPlayer p_70100_1_) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(float p_70239_1_) {
        this.damage = p_70239_1_;
    }

    public boolean canAttackWithItem() {
        return false;
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon;
    }

    public int getColor() {
        return this.color;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    public boolean isAffectedByAnomaly(IGravitationalAnomaly anomaly) {
        return false;
    }

    @Override
    public void onEntityConsumed(IGravitationalAnomaly anomaly) {
    }

    public void setFireDamageMultiply(float fiery) {
        this.fireDamageMultiply = fiery;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.damage);
        buffer.writeInt(this.color);
        buffer.writeFloat(this.fireDamageMultiply);
        buffer.writeInt(this.life);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.damage = additionalData.readFloat();
        this.color = additionalData.readInt();
        this.fireDamageMultiply = additionalData.readFloat();
        this.life = additionalData.readInt();
    }

    public float getLife() {
        return 1.0f - (float)this.distanceTraveled / (float)this.life;
    }

    public float setLife(float life) {
        return life;
    }

    public float getRenderSize() {
        return this.renderSize;
    }

    public void setRenderSize(float size) {
        this.renderSize = size;
    }

    public void setKnockBack(float knockback) {
        this.knockback = knockback;
    }

    public void markRicochetable() {
        this.canRicoche = true;
    }

    public void setExplodeMultiply(float explodeMultiply) {
        this.explodeMultiply = explodeMultiply;
    }
}

