/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.fx;

import matteroverdrive.client.data.Color;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class MOEntityFX
extends Particle {
    protected float renderDistanceWeight;

    public MOEntityFX(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        super(world, posX, posY, posZ, xSpeed, ySpeed, zSpeed);
    }

    protected MOEntityFX(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    public void setColorRGBA(Color color) {
        this.field_70552_h = color.getFloatR();
        this.field_70553_i = color.getFloatG();
        this.field_70551_j = color.getFloatB();
        this.field_82339_as = color.getFloatA();
    }

    public void setParticleMaxAge(int maxAge) {
        this.field_70547_e = maxAge;
    }

    public void setRenderDistanceWeight(float renderDistanceWeight) {
        this.renderDistanceWeight = renderDistanceWeight;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRender3d(double x, double y, double z) {
        double d0 = this.field_187126_f - x;
        double d1 = this.field_187127_g - y;
        double d2 = this.field_187128_h - z;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return this.isInRangeToRenderDist(d3);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double distance) {
        double d0 = this.func_187116_l().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * (double)this.renderDistanceWeight) * d0;
    }
}

