/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.android.BionicStatGuiInfo;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.container.ContainerAndroidStation;
import matteroverdrive.container.slot.MOSlot;
import matteroverdrive.data.inventory.BionicSlot;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.gui.GuiConfig;
import matteroverdrive.gui.GuiWeaponStation;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementGroup2DScroll;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.ElementParallaxBackground;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButtonScaled;
import matteroverdrive.gui.element.android_station.ElementBioStat;
import matteroverdrive.gui.element.android_station.ElementDoubleHelix;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.TileEntityAndroidStation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GuiAndroidStation
extends MOGuiMachine<TileEntityAndroidStation> {
    private static int scrollX;
    private static int scrollY;
    ElementSlot[] parts_slots = new ElementSlot[6];
    private EntityMeleeRougeAndroidMob mob;
    private MOElementButtonScaled hudConfigs;
    private ElementGroup2DScroll abilitiesGroup;
    private ElementDoubleHelix doubleHelix;

    public GuiAndroidStation(InventoryPlayer inventoryPlayer, TileEntityAndroidStation machine) {
        super(new ContainerAndroidStation(inventoryPlayer, machine), machine, 364, 280);
        this.texW = 255;
        this.texH = 237;
        AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)inventoryPlayer.field_70458_d);
        this.background = GuiWeaponStation.BG;
        for (int i = 0; i < this.parts_slots.length; ++i) {
            this.parts_slots[i] = new ElementInventorySlot((MOGuiBase)this, (MOSlot)this.field_147002_h.func_75139_a(i), 20, 20, "holo", androidPlayer.getInventory().getSlot(i).getHoloIcon());
            this.parts_slots[i].setColor(Reference.COLOR_MATTER.getIntR(), Reference.COLOR_MATTER.getIntG(), Reference.COLOR_MATTER.getIntB(), 78);
            this.parts_slots[i].setInfo("biopart." + BionicSlot.names[i] + ".name");
        }
        this.parts_slots[0].setPosition(220, this.field_147000_g - 110);
        this.parts_slots[1].setPosition(220, this.field_147000_g - 80);
        this.parts_slots[2].setPosition(220, this.field_147000_g - 50);
        this.parts_slots[3].setPosition(320, this.field_147000_g - 110);
        this.parts_slots[4].setPosition(320, this.field_147000_g - 80);
        this.parts_slots[5].setPosition(320, this.field_147000_g - 50);
        this.parts_slots[5].setIcon(ClientProxy.holoIcons.getIcon("battery"));
        this.abilitiesGroup = new ElementGroup2DScroll(this, 46, 30, 300, 155);
        this.abilitiesGroup.setScrollBounds(-270, 370, -300, 300);
        this.abilitiesGroup.setScroll(scrollX, scrollY);
        ElementParallaxBackground background = new ElementParallaxBackground(this, 0, 0, this.abilitiesGroup.getWidth(), this.abilitiesGroup.getHeight(), false, 0.005f);
        background.setTexture("matteroverdrive:textures/gui/elements/grid_bg.png", 32, 32);
        background.setPosZ(-10);
        background.setColor(Reference.COLOR_HOLO.multiply(1.0f, 1.0f, 1.0f, 0.1f));
        this.doubleHelix = new ElementDoubleHelix(this, 0, 0, 320, 240, 2.0f);
        this.doubleHelix.setPointColor(Reference.COLOR_HOLO.multiply(1.0f, 1.0f, 1.0f, 0.3f));
        this.doubleHelix.setLineColor(Reference.COLOR_HOLO.multiply(1.0f, 1.0f, 1.0f, 0.15f));
        this.doubleHelix.setFillColor(Reference.COLOR_HOLO.multiply(0.3f, 0.3f, 0.3f, 0.2f));
        this.abilitiesGroup.addElement(background);
        for (IBioticStat stat : MatterOverdrive.STAT_REGISTRY.getStats()) {
            int unlockedLevel;
            BionicStatGuiInfo guiInfo = stat.getGuiInfo(androidPlayer, unlockedLevel = androidPlayer.getUnlockedLevel(stat));
            if (guiInfo == null) continue;
            ElementBioStat statElement = new ElementBioStat(this, guiInfo.getPosX(), guiInfo.getPosY(), stat, unlockedLevel, androidPlayer);
            statElement.setDirection(guiInfo.getDirection());
            statElement.setStrongConnection(guiInfo.isStrongConnection());
            this.abilitiesGroup.addElement(statElement);
        }
        this.mob = new EntityMeleeRougeAndroidMob((World)Minecraft.func_71410_x().field_71441_e);
        this.mob.getEntityData().func_74757_a("Hologram", true);
        this.hudConfigs = new MOElementButtonScaled(this, this, 48, 64, "hud_configs", 128, 24);
        this.hudConfigs.setText("HUD Options");
    }

    public void addStat(AndroidPlayer androidPlayer, IBioticStat stat, int x, int y, EnumFacing direction, boolean strong) {
        ElementBioStat elemStat = new ElementBioStat(this, 0, 0, stat, androidPlayer.getUnlockedLevel(stat), androidPlayer);
        elemStat.setDirection(direction);
        elemStat.setStrongConnection(strong);
        elemStat.setPosition(12 + x * 30, 6 + y * 30);
    }

    public void addStat(AndroidPlayer androidPlayer, IBioticStat stat, int x, int y, EnumFacing direction) {
        this.addStat(androidPlayer, stat, x, y, direction, false);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.abilitiesGroup);
        for (ElementSlot elementSlot : this.parts_slots) {
            ((ElementBaseGroup)this.pages.get(0)).addElement(elementSlot);
        }
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.hudConfigs);
        this.AddMainPlayerSlots(this.field_147002_h, this);
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
    }

    @Override
    protected void func_146976_a(float partialTick, int x, int y) {
        super.func_146976_a(partialTick, x, y);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        scrollX = this.abilitiesGroup.getScrollX();
        scrollY = this.abilitiesGroup.getScrollY();
        if (((ElementBaseGroup)this.pages.get(0)).isVisible()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            this.drawEntityOnScreen(280, this.field_147000_g - 25, 50, -this.mouseX + 280, -this.mouseY + this.field_147000_g - 100, (EntityLivingBase)this.field_146297_k.field_71439_g);
            GlStateManager.func_179121_F();
            String info = Minecraft.func_71410_x().field_71439_g.field_71068_ca + " XP";
            GlStateManager.func_179140_f();
            int width = this.field_146289_q.func_78256_a(info);
            this.field_146289_q.func_78276_b(TextFormatting.GREEN + info, 280 - width / 2, this.field_147000_g - 20, 0xFFFFFF);
        }
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String elementName, int mouseButton) {
        super.handleElementButtonClick(element, elementName, mouseButton);
        if (element.equals(this.hudConfigs)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiConfig((GuiScreen)this, "client.android_hud"));
        }
    }

    private void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)1.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)ent.field_70170_p.func_72820_D(), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ent.field_70761_aq = 0.0f;
        ent.field_70177_z = 0.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    static {
        scrollY = 65;
    }
}

