/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.container.ContainerFalse;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementGuideCategory;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementButtonScaled;
import matteroverdrive.gui.pages.PageActiveQuests;
import matteroverdrive.gui.pages.PageGuideDescription;
import matteroverdrive.gui.pages.PageGuideEntries;
import matteroverdrive.guide.GuideCategory;
import matteroverdrive.network.packet.server.PacketDataPadCommands;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;

public class GuiDataPad
extends MOGuiBase {
    public static final ResourceLocation BG = new ResourceLocation("matteroverdrive:textures/gui/pad.png");
    public MOElementButtonScaled abandonQuestButton;
    public MOElementButtonScaled completeQuestButton;
    PageGuideDescription guideDescription;
    PageGuideEntries guideEntries;
    PageActiveQuests activeQuests;
    MOElementButtonScaled activeQuestsButton;
    ItemStack dataPad;
    EnumHand hand;

    public GuiDataPad(EnumHand hand, ItemStack dataPadStack) {
        super(new ContainerFalse(), 300, 260);
        this.background = new ScaleTexture(BG, 93, 115).setOffsets(46, 46, 40, 73);
        this.dataPad = dataPadStack;
        this.hand = hand;
        this.setPage(MatterOverdrive.ITEMS.dataPad.getPage(dataPadStack));
        this.guideEntries.setDataPadStack(hand, dataPadStack);
        this.guideDescription.setDataPadStack(hand, dataPadStack);
        this.activeQuests.setDataPadStack(hand, dataPadStack);
    }

    @Override
    public void registerPages(MOBaseContainer container) {
        this.guideDescription = new PageGuideDescription(this, 14, 14, this.field_146999_f - 28, this.field_147000_g - 14 - 49, "Guide Description");
        this.guideEntries = new PageGuideEntries(this, 14, 14, this.field_146999_f - 28, this.field_147000_g - 14 - 49, "Guide Entries", this.guideDescription);
        this.activeQuests = new PageActiveQuests(this, 0, 0, this.field_146999_f - 28, this.field_147000_g - 28, "Active Quests", MOPlayerCapabilityProvider.GetExtendedCapability((Entity)Minecraft.func_71410_x().field_71439_g));
        this.activeQuestsButton = new MOElementButtonScaled(this, this, this.field_146999_f - 96, this.field_147000_g - 28, "", 22, 22);
        this.activeQuestsButton.setDisabledTexture(MOElementButton.HOVER_TEXTURE_DARK);
        this.activeQuestsButton.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.quest.active_quests", new Object[0]));
        this.activeQuestsButton.setIcon(ClientProxy.holoIcons.getIcon("question_mark"));
        this.completeQuestButton = new MOElementButtonScaled(this, this.activeQuests, this.field_146999_f - 72, this.field_147000_g - 28, "complete_quest", 22, 22);
        this.completeQuestButton.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.quest.complete", new Object[0]));
        this.completeQuestButton.setIcon(ClientProxy.holoIcons.getIcon("tick"));
        this.completeQuestButton.setTextColor(Reference.COLOR_HOLO_GREEN.getColor());
        this.completeQuestButton.setDisabledTexture(MOElementButton.HOVER_TEXTURE_DARK);
        this.abandonQuestButton = new MOElementButtonScaled(this, this.activeQuests, this.field_146999_f - 48, this.field_147000_g - 24, "abandon_quest", 16, 16);
        this.abandonQuestButton.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.quest.abandon", new Object[0]));
        this.abandonQuestButton.setIcon(ClientProxy.holoIcons.getIcon("mini_quit"));
        this.abandonQuestButton.setTextColor(Reference.COLOR_HOLO_RED.getColor());
        this.abandonQuestButton.setDisabledTexture(MOElementButton.HOVER_TEXTURE_DARK);
        this.AddPage(this.guideEntries, ClientProxy.holoIcons.getIcon("page_icon_home"), "Guide Entries");
        this.AddPage(this.guideDescription, ClientProxy.holoIcons.getIcon("page_icon_search"), MOStringHelper.translateToLocal("gui.tooltip.page.info_database", new Object[0]));
        this.AddPage(this.activeQuests, ClientProxy.holoIcons.getIcon("page_icon_quests"), MOStringHelper.translateToLocal("gui.tooltip.page.active_quests", new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.elements.remove(this.sidePannel);
        this.closeButton.setPosition(this.field_146999_f - 32, 20);
        for (ElementGuideCategory category : this.guideEntries.getCategories()) {
            this.addElement(category);
        }
        this.addElement(this.activeQuestsButton);
        this.addElement(this.abandonQuestButton);
        this.addElement(this.completeQuestButton);
    }

    public void refreshQuests(OverdriveExtendedProperties extendedProperties) {
        this.activeQuests.refreshQuests(extendedProperties);
    }

    @Override
    public void onPageChange(int newPage) {
        if (newPage != MatterOverdrive.ITEMS.dataPad.getPage(this.dataPad)) {
            MatterOverdrive.ITEMS.dataPad.setOpenPage(this.dataPad, newPage);
            MatterOverdrive.NETWORK.sendToServer(new PacketDataPadCommands(this.hand, this.dataPad));
        }
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        GuideCategory category = this.guideEntries.getActiveCategory();
        for (int i = 0; i < this.guideEntries.getCategories().size(); ++i) {
            if (category.equals(this.guideEntries.getCategories().get(i).getCategory()) && this.currentPage <= 1) {
                this.guideEntries.getCategories().get(i).setEnabled(false);
            } else {
                this.guideEntries.getCategories().get(i).setEnabled(true);
            }
            this.guideEntries.getCategories().get(i).setPosition(16 + 32 * i, this.field_147000_g - 28);
        }
        if (this.currentPage == 2) {
            this.activeQuestsButton.setEnabled(false);
            this.abandonQuestButton.setVisible(true);
            this.completeQuestButton.setVisible(true);
        } else {
            this.activeQuestsButton.setEnabled(true);
            this.abandonQuestButton.setVisible(false);
            this.completeQuestButton.setVisible(false);
        }
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        super.handleElementButtonClick(element, buttonName, mouseButton);
        if (element == this.activeQuestsButton) {
            this.setPage(2);
        }
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
    }

    public PageGuideDescription getGuideDescription() {
        return this.guideDescription;
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.activeQuests.onGuiClose();
    }
}

