/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.container.MOBaseContainer;
import matteroverdrive.container.matter_network.ContainerPatternMonitor;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.data.matter_network.ItemPatternMapping;
import matteroverdrive.gui.MOGuiNetworkMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementMonitorItemPattern;
import matteroverdrive.gui.element.ElementPatternsGrid;
import matteroverdrive.gui.element.ElementTaskList;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementTextField;
import matteroverdrive.gui.pages.PageTasks;
import matteroverdrive.machines.pattern_monitor.TileEntityMachinePatternMonitor;
import matteroverdrive.network.packet.server.pattern_monitor.PacketPatternMonitorAddRequest;
import matteroverdrive.network.packet.server.task_queue.PacketRemoveTask;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class GuiPatternMonitor
extends MOGuiNetworkMachine<TileEntityMachinePatternMonitor> {
    MOElementButton refreshButton;
    MOElementButton requestButton;
    ElementPatternsGrid elementGrid;
    PageTasks pageTasks;
    MOElementTextField searchField;

    public GuiPatternMonitor(InventoryPlayer inventoryPlayer, TileEntityMachinePatternMonitor machine) {
        super(new ContainerPatternMonitor(inventoryPlayer, machine), machine);
        this.name = "pattern_monitor";
        this.refreshButton = new MOElementButton(this, this, 6, 45, "Refresh", 0, 0, 22, 0, 22, 22, "");
        this.refreshButton.setTexture("matteroverdrive:textures/gui/items/refresh.png", 44, 22);
        this.refreshButton.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.button.refresh", new Object[0]));
        this.requestButton = new MOElementButton(this, this, 6, 75, "Request", 0, 0, 22, 0, 22, 22, "");
        this.requestButton.setTexture("matteroverdrive:textures/gui/items/request.png", 44, 22);
        this.requestButton.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.button.request", new Object[0]));
        this.elementGrid = new ElementPatternsGrid(this, 48, 40, 160, 110);
        this.searchField = new MOElementTextField(this, 41, 26, 167, 14);
        this.slotsList.addElement(this.requestButton);
    }

    @Override
    public void registerPages(MOBaseContainer container, TileEntityMachinePatternMonitor machine) {
        super.registerPages(container, machine);
        this.pageTasks = new PageTasks(this, 0, 0, this.field_146999_f, this.field_147000_g, machine.getTaskQueue(0));
        this.pageTasks.setName("Tasks");
        this.AddPage(this.pageTasks, ClientProxy.holoIcons.getIcon("page_icon_tasks"), MOStringHelper.translateToLocal("gui.tooltip.page.tasks", new Object[0])).setIconColor(Reference.COLOR_MATTER);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.elementGrid);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.searchField);
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        super.handleElementButtonClick(element, buttonName, mouseButton);
        if (element == this.requestButton) {
            for (int i = 0; i < this.elementGrid.getElements().size(); ++i) {
                if (!(this.elementGrid.getElements().get(i) instanceof ElementMonitorItemPattern)) continue;
                ElementMonitorItemPattern itemPattern = (ElementMonitorItemPattern)this.elementGrid.getElements().get(i);
                if (itemPattern.getAmount() > 0) {
                    ItemPattern pattern = itemPattern.getPatternMapping().getItemPattern().copy();
                    MatterOverdrive.NETWORK.sendToServer(new PacketPatternMonitorAddRequest((TileEntityMachinePatternMonitor)this.machine, pattern, itemPattern.getAmount()));
                    itemPattern.setAmount(0);
                    continue;
                }
                itemPattern.setExpanded(false);
            }
        } else if (element instanceof ElementTaskList) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("TaskID", mouseButton);
            MatterOverdrive.NETWORK.sendToServer(new PacketRemoveTask(this.machine, mouseButton, 0, MatterNetworkTaskState.INVALID));
        }
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        this.elementGrid.setFilter(this.searchField.getText());
    }

    public void setPattern(ItemPatternMapping pattern) {
        this.elementGrid.setPattern(pattern);
    }

    public void clearPatterns(BlockPos database, int storageId) {
        this.elementGrid.removePatterns(database, storageId);
    }

    public void clearPatterns(BlockPos database) {
        this.elementGrid.removePatterns(database);
    }

    public void clearPatterns() {
        this.elementGrid.clearElements();
    }
}

