/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.android;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.client.data.Color;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.gui.android.AndroidHudElement;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.gui.android.AndroidHudStats;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class AndroidHudBionicStats
extends AndroidHudElement {
    private static final int STATS_PER_ROW = 6;
    private int lastHeightCount = 0;

    public AndroidHudBionicStats(AndroidHudPosition position, String name) {
        super(position, name, 174, 0);
    }

    @Override
    public boolean isVisible(AndroidPlayer android) {
        return true;
    }

    @Override
    public void drawElement(AndroidPlayer android, ScaledResolution resolution, float ticks) {
        GlStateManager.func_179141_d();
        int count = 0;
        for (int i = 0; i < android.func_70302_i_(); ++i) {
            if (android.func_70301_a(i).func_190926_b()) continue;
            this.drawAndroidPart(android.func_70301_a(i), this.baseColor, this.getX(count, resolution, android), this.getY(count, resolution, android));
            ++count;
        }
        for (Object object : android.getUnlockedNBT().func_150296_c()) {
            int level;
            IBioticStat stat = MatterOverdrive.STAT_REGISTRY.getStat(object.toString());
            if (stat == null || !stat.showOnHud(android, level = android.getUnlockedLevel(stat))) continue;
            if (!stat.isEnabled(android, level)) {
                this.drawBioticStat(stat, android, level, Reference.COLOR_HOLO_RED, this.getX(count, resolution, android), this.getY(count, resolution, android));
            } else {
                this.drawBioticStat(stat, android, level, this.baseColor, this.getX(count, resolution, android), this.getY(count, resolution, android));
            }
            ++count;
        }
        GlStateManager.func_179112_b((int)770, (int)1);
        RenderUtils.applyColorWithAlpha(this.baseColor);
        if (this.getPosition().y == 1.0f) {
            this.mc.field_71446_o.func_110577_a(AndroidHudStats.top_element_bg);
            RenderUtils.drawPlane(12.0f - 24.0f * this.getPosition().x, Math.ceil((double)count / 6.0) * 24.0 + 4.0, 0.0, 174.0, 11.0);
        } else if ((double)this.getPosition().y == 0.5) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(22.0f + (float)(this.getWidth(resolution, android) - 24) * this.getPosition().x), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(AndroidHudStats.top_element_bg);
            RenderUtils.drawPlane(0.0, 0.0, 0.0, 174.0, 11.0);
            GlStateManager.func_179121_F();
        } else {
            this.mc.field_71446_o.func_110577_a(AndroidHudStats.top_element_bg);
            RenderUtils.drawPlane(12.0f - 24.0f * this.getPosition().x, 10.0, 0.0, 174.0, 11.0);
        }
        this.lastHeightCount = count;
        GlStateManager.func_179147_l();
    }

    private int getTotalElementCount(AndroidPlayer android) {
        int count = 0;
        for (int i = 0; i < android.func_70302_i_(); ++i) {
            if (android.func_70301_a(i).func_190926_b()) continue;
            ++count;
        }
        for (Object object : android.getUnlockedNBT().func_150296_c()) {
            int level;
            IBioticStat stat = MatterOverdrive.STAT_REGISTRY.getStat(object.toString());
            if (stat == null || !stat.showOnHud(android, level = android.getUnlockedLevel(stat))) continue;
            ++count;
        }
        return count;
    }

    private void drawAndroidPart(ItemStack stack, Color color, int x, int y) {
        this.drawNormalBG(color, x, y);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179112_b((int)770, (int)1);
        RenderUtils.renderStack(x + 3, y + 3, stack);
    }

    private void drawBioticStat(IBioticStat stat, AndroidPlayer androidPlayer, int level, Color color, int x, int y) {
        if (stat.isActive(androidPlayer, level) && stat.isEnabled(androidPlayer, level)) {
            this.drawActiveBG(color, x, y);
        } else {
            this.drawNormalBG(color, x, y);
        }
        ClientProxy.holoIcons.renderIcon(stat.getIcon(level), (double)(x + 2), (double)(y + 2), 18, 18);
        if (stat.getDelay(androidPlayer, level) > 0) {
            String delay = MOStringHelper.formatRemainingTime((float)stat.getDelay(androidPlayer, level) / 20.0f, true);
            int delayWidth = ClientProxy.moFontRender.func_78256_a(delay);
            ClientProxy.moFontRender.func_78276_b(delay, x + 22 - delayWidth, y + 22 - ClientProxy.moFontRender.field_78288_b - 1, Reference.COLOR_HOLO.getColor());
        }
    }

    private void drawNormalBG(Color color, int x, int y) {
        GlStateManager.func_179120_a((int)770, (int)771, (int)770, (int)771);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)this.backgroundAlpha);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg_black", (double)x, (double)y, 22, 22);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)1, (int)770, (int)1);
        RenderUtils.applyColorWithAlpha(color);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg", (double)x, (double)y, 22, 22);
        GlStateManager.func_179084_k();
    }

    private void drawActiveBG(Color color, int x, int y) {
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)this.backgroundAlpha);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg_black", (double)x, (double)y, 22, 22);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        RenderUtils.applyColorWithAlpha(color);
        ClientProxy.holoIcons.renderIcon("android_feature_icon_bg_active", (double)x, (double)y, 22, 22);
        GlStateManager.func_179084_k();
    }

    private int getX(int count, ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if ((double)this.getPosition().y == 0.5) {
            return Math.floorDiv(count, this.getHeight(resolution, androidPlayer) / 24) * 24 + 22 - (int)(44.0f * this.getPosition().x);
        }
        return 24 * (count % (this.getWidth(resolution, androidPlayer) / 24)) + 12 - (int)(22.0f * this.getPosition().x);
    }

    private int getY(int count, ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if ((double)this.getPosition().y == 0.5) {
            return 24 * (count % (this.getHeight(resolution, androidPlayer) / 24));
        }
        return Math.floorDiv(count, this.getWidth(resolution, androidPlayer) / 24) * 24 + 22 - (int)(22.0f * this.getPosition().y);
    }

    @Override
    public int getHeight(ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if ((double)this.getPosition().y == 0.5) {
            return this.width;
        }
        int count = this.getTotalElementCount(androidPlayer);
        return (int)Math.ceil((double)count * 24.0 / (double)this.width) * 24 + (int)(24.0f * this.getPosition().y);
    }

    @Override
    public int getWidth(ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if ((double)this.getPosition().y == 0.5) {
            int count = this.getTotalElementCount(androidPlayer);
            return (int)Math.ceil((double)count * 24.0 / (double)this.width) * 24;
        }
        return this.width;
    }
}

