/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.android;

import java.text.DecimalFormat;
import matteroverdrive.Reference;
import matteroverdrive.api.inventory.IEnergyPack;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.gui.android.AndroidHudElement;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class AndroidHudStats
extends AndroidHudElement {
    public static final ResourceLocation top_element_bg = new ResourceLocation("matteroverdrive:textures/gui/elements/android_bg_element.png");

    public AndroidHudStats(AndroidHudPosition position, String name) {
        super(position, name, 174, 32);
    }

    @Override
    public boolean isVisible(AndroidPlayer android) {
        return true;
    }

    @Override
    public void drawElement(AndroidPlayer androidPlayer, ScaledResolution resolution, float ticks) {
        GlStateManager.func_179141_d();
        double energy_perc = (double)androidPlayer.getEnergyStored() / (double)androidPlayer.getMaxEnergyStored();
        double health_perc = (double)androidPlayer.getPlayer().func_110143_aJ() / androidPlayer.getPlayer().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        int x = 0;
        int y = 0;
        if ((double)this.getPosition().y > 0.5) {
            y = -48;
        }
        if (this.getPosition().y == 0.0f || this.getPosition().y == 1.0f) {
            x = 12 - (int)(24.0f * this.getPosition().x);
            y = 12 - (int)(24.0f * this.getPosition().y);
            GlStateManager.func_179112_b((int)770, (int)1);
            RenderUtils.applyColorWithAlpha(this.baseColor);
            this.mc.field_71446_o.func_110577_a(top_element_bg);
            RenderUtils.drawPlane(x, (float)y + (float)(this.getHeight(resolution, androidPlayer) - 11) * this.getPosition().y, 0.0, 174.0, 11.0);
            y = (int)((float)y + (10.0f - 5.0f * this.getPosition().y));
            int statsX = x += 5;
            statsX = (int)((float)statsX - (float)(this.getWidthIconWithPercent(health_perc, 18) + this.getWidthIconWithPercent(energy_perc, 20) + this.getWidthIconWithPercent(androidPlayer.getSpeedMultiply(), 16)) * this.getPosition().x);
            statsX = (int)((float)statsX + 165.0f * this.getPosition().x);
            statsX += this.renderIconWithPercent("health", health_perc, statsX, y, 0, 0, false, Reference.COLOR_HOLO_RED, this.baseColor, 18, 18);
            statsX += this.renderIconWithPercent("battery", energy_perc, statsX, y, 0, -2, false, Reference.COLOR_HOLO_RED, this.baseColor, 20, 20);
            this.renderIconWithPercent("person", androidPlayer.getSpeedMultiply(), statsX, y, 0, 1, false, this.baseColor, this.baseColor, 14, 14);
            int weaponX = x;
            weaponX = (int)((float)weaponX - (float)(this.getAmmoBoxWidth(androidPlayer) + this.getHeatWidth(androidPlayer)) * this.getPosition().x);
            weaponX = (int)((float)weaponX + 165.0f * this.getPosition().x);
            weaponX += this.renderAmmoBox(androidPlayer, weaponX, y += 20, false, this.baseColor);
            this.renderHeat(androidPlayer, weaponX, y, false, this.baseColor);
        } else if (this.getPosition() == AndroidHudPosition.MIDDLE_LEFT || this.getPosition() == AndroidHudPosition.MIDDLE_RIGHT) {
            x = 12 - (int)(24.0f * this.getPosition().x);
            GlStateManager.func_179112_b((int)770, (int)1);
            RenderUtils.applyColorWithAlpha(this.baseColor);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(x + 11) + (float)(this.getWidth(resolution, androidPlayer) - 11) * this.getPosition().x), (float)y, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(top_element_bg);
            RenderUtils.drawPlane(0.0, 0.0, 0.0, 174.0, 11.0);
            GlStateManager.func_179121_F();
            y += 86;
            int ySize = 70;
            int ammoWidth = this.getAmmoBoxWidth(androidPlayer);
            int heatWidth = this.getHeatWidth(androidPlayer);
            int ammoHeight = ammoWidth == 0 ? 0 : 24;
            int heatHeight = heatWidth == 0 ? 0 : 24;
            ySize += ammoHeight;
            this.renderIconWithPercent("health", health_perc, (x += 11) + (int)((float)(this.getWidth(resolution, androidPlayer) - this.getWidthIconWithPercent(health_perc, 18) - 22) * this.getPosition().x), y -= (ySize += heatHeight) / 2, 0, 0, false, Reference.COLOR_HOLO_RED, this.baseColor, 18, 18);
            this.renderIconWithPercent("battery", energy_perc, x + (int)((float)(this.getWidth(resolution, androidPlayer) - this.getWidthIconWithPercent(energy_perc, 20) - 22) * this.getPosition().x), (y += 24) - 2, 0, -2, false, Reference.COLOR_HOLO_RED, this.baseColor, 20, 20);
            this.renderIconWithPercent("person", androidPlayer.getSpeedMultiply(), x + (int)((float)(this.getWidth(resolution, androidPlayer) - this.getWidthIconWithPercent(androidPlayer.getSpeedMultiply(), 16) - 22) * this.getPosition().x), y += 22, 0, 1, false, this.baseColor, this.baseColor, 16, 16);
            this.renderAmmoBox(androidPlayer, x + (int)((float)(this.getWidth(resolution, androidPlayer) - ammoWidth - 22) * this.getPosition().x), y += 24, false, this.baseColor);
            this.renderHeat(androidPlayer, x + (int)((float)(this.getWidth(resolution, androidPlayer) - heatWidth - 22) * this.getPosition().x), y += ammoHeight, false, this.baseColor);
        } else if (this.getPosition() == AndroidHudPosition.MIDDLE_CENTER) {
            this.renderIconWithPercent("health", health_perc, x - this.getWidthIconWithPercent(health_perc, 18) - 22, y - 8, 0, 0, true, Reference.COLOR_HOLO_RED, this.baseColor, 18, 18);
            this.renderIconWithPercent("battery", energy_perc, x + 24, y - 9, 0, 0, false, Reference.COLOR_HOLO_RED, this.baseColor, 20, 20);
        }
    }

    private int getWidthIconWithInfo(String info, int iconWidth) {
        return iconWidth + ClientProxy.moFontRender.func_78256_a(info) + 4;
    }

    private int getWidthIconWithPercent(double amount, int iconWidth) {
        return this.getWidthIconWithInfo(DecimalFormat.getPercentInstance().format(amount), iconWidth);
    }

    private int renderIconWithPercent(String icon, double amount, int x, int y, int iconOffsetX, int iconOffsetY, boolean leftSided, Color fromColor, Color toColor, int iconWidth, int iconHeight) {
        return this.renderIconWithInfo(icon, DecimalFormat.getPercentInstance().format(amount), RenderUtils.lerp(fromColor, toColor, MathHelper.func_76131_a((float)((float)amount), (float)0.0f, (float)1.0f)), x, y, iconOffsetX, iconOffsetY, leftSided, iconWidth, iconHeight);
    }

    private int renderIconWithInfo(String icon, String info, Color color, int x, int y, int iconOffsetX, int iconOffsetY, boolean leftSided, int iconWidth, int iconHeight) {
        HoloIcon holoIcon = ClientProxy.holoIcons.getIcon(icon);
        int infoWidth = ClientProxy.moFontRender.func_78256_a(info);
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)this.backgroundAlpha);
        RenderUtils.drawPlane(x, y - 1, 0.0, infoWidth + 2 + iconWidth + 2, 20.0);
        GlStateManager.func_179098_w();
        GlStateManager.func_179112_b((int)770, (int)1);
        RenderUtils.applyColorWithAlpha(color);
        if (!leftSided) {
            ClientProxy.holoIcons.renderIcon(holoIcon, (double)(x + iconOffsetX), (double)(y + iconOffsetY), iconWidth, iconHeight);
            ClientProxy.moFontRender.func_78276_b(info, x + iconWidth + 2 + iconOffsetX, y + iconWidth / 2 - ClientProxy.moFontRender.field_78288_b / 2 + iconOffsetY, color.getColor());
        } else {
            ClientProxy.moFontRender.func_78276_b(info, x + iconOffsetX, y + iconWidth / 2 - ClientProxy.moFontRender.field_78288_b / 2 + iconOffsetY, color.getColor());
            ClientProxy.holoIcons.renderIcon(icon, (double)(x + infoWidth + 2 + iconOffsetX), (double)(y + iconOffsetY), iconWidth, iconHeight);
        }
        return infoWidth + 2 + iconWidth + 2;
    }

    private int renderAmmoBox(AndroidPlayer androidPlayer, int x, int y, boolean leftSided, Color baseColor) {
        if (androidPlayer.getPlayer() != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND) != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon) {
            float percent = (float)((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getAmmo(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND)) / (float)((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getMaxAmmo(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND));
            int energyPackCount = this.getEnergyPackCount(androidPlayer.getPlayer());
            return this.renderIconWithInfo("ammo", DecimalFormat.getPercentInstance().format(percent) + " | " + Integer.toString(energyPackCount), RenderUtils.lerp(Reference.COLOR_HOLO_RED, baseColor, percent), x, y, 0, 0, leftSided, 18, 18);
        }
        return 0;
    }

    private int getAmmoBoxWidth(AndroidPlayer androidPlayer) {
        if (androidPlayer.getPlayer() != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND) != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon) {
            float percent = (float)((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getAmmo(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND)) / (float)((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getMaxAmmo(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND));
            int energyPackCount = this.getEnergyPackCount(androidPlayer.getPlayer());
            return this.getWidthIconWithInfo(DecimalFormat.getPercentInstance().format(percent) + " | " + Integer.toString(energyPackCount), 18);
        }
        return 0;
    }

    private int renderHeat(AndroidPlayer androidPlayer, int x, int y, boolean leftSided, Color baseColor) {
        if (androidPlayer.getPlayer() != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND) != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon && ((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getMaxHeat(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND)) > 0.0f) {
            float percent = ((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getHeat(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND)) / ((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getMaxHeat(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND));
            return this.renderIconWithPercent("temperature", percent, x, y, 0, 0, leftSided, baseColor, Reference.COLOR_HOLO_RED, 18, 18);
        }
        return 0;
    }

    private int getHeatWidth(AndroidPlayer androidPlayer) {
        if (androidPlayer.getPlayer() != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND) != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon && ((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getMaxHeat(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND)) > 0.0f) {
            float percent = ((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getHeat(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND)) / ((IWeapon)androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getMaxHeat(androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND));
            return this.getWidthIconWithPercent(percent, 18);
        }
        return 0;
    }

    private int getEnergyPackCount(EntityPlayer entityPlayer) {
        int energyPackCount = 0;
        for (ItemStack stack : entityPlayer.field_71071_by.field_70462_a) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEnergyPack)) continue;
            energyPackCount += stack.func_190916_E();
        }
        return energyPackCount;
    }

    @Override
    public int getWidth(ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if (this.getPosition() == AndroidHudPosition.MIDDLE_CENTER) {
            return 0;
        }
        if ((double)this.getPosition().y == 0.5) {
            return Math.max(this.getAmmoBoxWidth(androidPlayer) + 16, this.getWidthIconWithPercent(1000.0, 18));
        }
        return this.width;
    }

    @Override
    public int getHeight(ScaledResolution resolution, AndroidPlayer androidPlayer) {
        if (this.getPosition() == AndroidHudPosition.MIDDLE_CENTER) {
            return 0;
        }
        if ((double)this.getPosition().y == 0.5) {
            return this.width;
        }
        if (androidPlayer.getPlayer() != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND) != null && androidPlayer.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IWeapon) {
            return this.height + 20;
        }
        return this.height;
    }
}

