/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.util.RenderUtils;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.renderer.GlStateManager;

public class ElementScrollGroup
extends ElementBaseGroup {
    int contentTotalHeight;
    int scroll;
    float scrollSmooth;
    int scrollSpeed = 10;
    int scrollerColor;

    public ElementScrollGroup(MOGuiBase gui, int posX, int posY, int width, int height) {
        super(gui, posX, posY, width, height);
    }

    private void manageDrag(int maxHeight) {
        this.scrollSmooth = MOMathHelper.Lerp(this.scrollSmooth, this.scroll, 0.1f);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.contentTotalHeight = 0;
        for (MOElementBase element : this.elements) {
            element.setPosition(element.getPosX(), Math.round((float)this.contentTotalHeight + this.scrollSmooth));
            element.setVisible(true);
            this.contentTotalHeight += element.getHeight();
        }
        this.manageDrag(Math.max(0, this.contentTotalHeight - this.sizeY));
        RenderUtils.beginStencil();
        this.drawStencil(this.posX, this.posY, this.posX + this.sizeX, this.posY + this.sizeY, 1);
        super.drawBackground(mouseX, mouseY, gameTicks);
        RenderUtils.endStencil();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        RenderUtils.beginDrawingDepthMask();
        RenderUtils.drawPlane(this.posX, this.posY, 100.0, this.sizeX, this.sizeY);
        RenderUtils.beginDepthMasking();
        super.drawForeground(mouseX, mouseY);
        GlStateManager.func_179090_x();
        RenderUtils.applyColor(this.scrollerColor);
        if (this.contentTotalHeight - this.sizeY > 0) {
            int maxScroll = this.contentTotalHeight - this.sizeY;
            float scrollPercent = -this.scrollSmooth / (float)maxScroll;
            int scrollerSize = (int)((float)this.sizeY / (float)this.contentTotalHeight * (float)this.sizeY);
            int scrollerY = this.sizeY - scrollerSize;
            RenderUtils.drawPlane(this.posX + this.sizeX - 1, (float)this.posY + (float)scrollerY * scrollPercent, 0.0, 1.0, scrollerSize);
        }
        GlStateManager.func_179098_w();
        RenderUtils.endDepthMask();
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (movement > 0) {
            this.scrollUp();
        } else if (movement < 0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        this.scroll -= this.scrollSpeed;
        this.scroll = Math.max(this.scroll, -Math.max(0, this.contentTotalHeight - this.sizeY));
    }

    public void scrollUp() {
        if (this.scroll < 0) {
            this.scroll = Math.min(this.scroll + this.scrollSpeed, 0);
        }
    }

    public void setScrollerColor(int color) {
        this.scrollerColor = color;
    }

    public int getScroll() {
        return this.scroll;
    }

    public void setScroll(int scroll) {
        this.scroll = scroll;
    }
}

