/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.client.render.HoloIcon;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class ElementSlot
extends MOElementBase {
    protected HoloIcon icon;
    protected String type = "small";
    protected int iconOffsetX = (this.sizeX - 16) / 2;
    protected int iconOffsetY = (this.sizeY - 16) / 2;
    protected String info = "";

    public ElementSlot(MOGuiBase gui, int posX, int posY, int width, int height, String type, HoloIcon icon) {
        super(gui, posX, posY, width, height);
        this.type = type;
        this.icon = icon;
    }

    public ElementSlot(MOGuiBase gui, int posX, int posY, int width, int height, String type) {
        this(gui, posX, posY, width, height, type, null);
    }

    public static ResourceLocation getTexture(String type) {
        return new ResourceLocation("matteroverdrive:textures/gui/elements/slot_" + type + ".png");
    }

    @Override
    public void addTooltip(List<String> list, int mouseX, int mouseY) {
        if (!this.info.isEmpty()) {
            list.add(MOStringHelper.translateToLocal(this.info, new Object[0]));
        }
    }

    @Override
    public void updateInfo() {
    }

    @Override
    public void init() {
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.ApplyColor();
        this.gui.bindTexture(ElementSlot.getTexture(this.type));
        this.gui.drawSizedTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY, this.sizeX, this.sizeY);
        this.drawSlotIcon(this.icon, this.posX + this.iconOffsetX, this.posY + this.iconOffsetY);
        this.ResetColor();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    public void drawSlotIcon(HoloIcon icon, int x, int y) {
        if (icon != null && this.canDrawIcon(icon)) {
            GlStateManager.func_179147_l();
            this.ApplyColor();
            GlStateManager.func_179112_b((int)770, (int)771);
            ClientProxy.holoIcons.bindSheet();
            ClientProxy.holoIcons.renderIcon(icon, (double)x, (double)y);
            GlStateManager.func_179084_k();
            this.ResetColor();
        }
    }

    protected boolean canDrawIcon(HoloIcon icon) {
        return true;
    }

    public void setItemOffset(int x, int y) {
        this.iconOffsetX = x;
        this.iconOffsetY = y;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public HoloIcon getIcon() {
        return this.icon;
    }

    public void setIcon(HoloIcon icon) {
        this.icon = icon;
    }

    public void setType(String type) {
        this.type = type;
    }
}

