/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import matteroverdrive.Reference;
import matteroverdrive.api.transport.TransportLocation;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.IMOListBoxElement;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementListBox;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.machines.transporter.TileEntityMachineTransporter;

public class ElementTransportList
extends MOElementListBox {
    TileEntityMachineTransporter transporter;

    public ElementTransportList(MOGuiBase containerScreen, IListHandler listHandler, int x, int y, int width, int height, TileEntityMachineTransporter transporter) {
        super(containerScreen, listHandler, x, y, width, height);
        this.transporter = transporter;
    }

    @Override
    public void DrawElement(int i, int x, int y, int selectedLineColor, int selectedTextColor, boolean selected, boolean BG) {
        TransportLocation position = this.transporter.getPositions().get(i);
        if (BG) {
            if (selected && this.transporter.isLocationValid(position)) {
                MOElementButton.NORMAL_TEXTURE.render(x, y, this.getElementWidth(i), this.getElementHeight(i));
            } else {
                MOElementButton.HOVER_TEXTURE_DARK.render(x, y, this.getElementWidth(i), this.getElementHeight(i));
            }
        } else {
            String info = "[ X: " + (position.pos.func_177958_n() + this.transporter.func_174877_v().func_177958_n()) + ", Y: " + (position.pos.func_177956_o() + this.transporter.func_174877_v().func_177956_o()) + ", Z: " + (position.pos.func_177952_p() + this.transporter.func_174877_v().func_177952_p()) + " ]";
            this.gui.func_73732_a(this.getFontRenderer(), position.name, x + this.getElementWidth(i) / 2, y + this.getElementHeight(i) / 2 - 4, this.transporter.isLocationValid(position) ? selectedTextColor : Reference.COLOR_HOLO_RED.getColor());
        }
    }

    @Override
    public void drawElementTooltip(int index, int mouseX, int mouseY) {
    }

    @Override
    public int getElementHeight(int id) {
        return 20;
    }

    @Override
    public int getElementWidth(int id) {
        return this.sizeX - 4;
    }

    @Override
    protected boolean shouldBeDisplayed(IMOListBoxElement element) {
        return true;
    }

    @Override
    public IMOListBoxElement getElement(int index) {
        return null;
    }

    @Override
    public int getElementCount() {
        return this.transporter.getPositions().size();
    }
}

