/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import matteroverdrive.client.data.Color;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.IMOListBoxElement;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.events.IListHandler;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class MOElementListBox
extends MOElementBase {
    private final int _marginTop = 2;
    private final int _marginLeft = 2;
    private final int _marginRight = 2;
    private final int _marginBottom = 2;
    private final List<IMOListBoxElement> _elements = new LinkedList<IMOListBoxElement>();
    public int borderColor = new Color(120, 120, 120, 255).getColor();
    public int backgroundColor = new Color(0, 0, 0, 255).getColor();
    public int selectedLineColor = new Color(0, 0, 0, 255).getColor();
    public int textColor = new Color(150, 150, 150, 255).getColor();
    public int selectedTextColor = new Color(255, 255, 255, 255).getColor();
    protected int _selectedIndex;
    IListHandler listHandler;
    private int _firstIndexDisplayed;
    private int scrollHoriz;

    public MOElementListBox(MOGuiBase containerScreen, IListHandler listHandler, int x, int y, int width, int height) {
        super(containerScreen, x, y, width, height);
        this.listHandler = listHandler;
    }

    public MOElementListBox(MOGuiBase containerScreen, int x, int y, int width, int height) {
        this(containerScreen, containerScreen, x, y, width, height);
    }

    @Override
    public void updateInfo() {
    }

    @Override
    public void init() {
    }

    @Override
    public void addTooltip(List<String> var1, int mouseX, int mouseY) {
    }

    public void add(IMOListBoxElement element) {
        this._elements.add(element);
    }

    public void add(Collection<? extends IMOListBoxElement> elements) {
        this._elements.addAll(elements);
    }

    public void remove(IMOListBoxElement element) {
        this._elements.remove(element);
    }

    public void removeAt(int index) {
        this._elements.remove(index);
    }

    public void clear() {
        this._elements.clear();
    }

    public int getInternalWidth() {
        int width = 0;
        for (int i = 0; i < this.getElementCount(); ++i) {
            width = Math.max(this.getElementWidth(i), width);
        }
        return width;
    }

    public int getInternalHeight() {
        int height = 0;
        for (int i = 0; i < this.getElementCount(); ++i) {
            height += this.getElementHeight(i);
        }
        return height;
    }

    public int getContentWidth() {
        return this.sizeX - 2 - 2;
    }

    public int getContentHeight() {
        return this.sizeY - 2 - 2;
    }

    public int getContentTop() {
        return this.posY + 2;
    }

    public int getContentLeft() {
        return this.posX + 2;
    }

    public final int getContentBottom() {
        return this.getContentTop() + this.getContentHeight();
    }

    public final int getContentRight() {
        return this.getContentLeft() + this.getContentWidth();
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        int heightDrawn = 0;
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        RenderUtils.beginStencil();
        this.drawStencil(this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 1);
        GlStateManager.func_179109_b((float)(-this.scrollHoriz), (float)0.0f, (float)0.0f);
        int e = this.getElementCount();
        for (int nextElement = this._firstIndexDisplayed; nextElement < e && heightDrawn <= this.getContentHeight(); ++nextElement) {
            if (!this.shouldBeDisplayed(this.getElement(nextElement))) continue;
            if (this._selectedIndex == nextElement) {
                this.DrawElement(nextElement, this.getContentLeft(), this.getContentTop() + heightDrawn, this.selectedLineColor, this.selectedTextColor, true, true);
            } else {
                this.DrawElement(nextElement, this.getContentLeft(), this.getContentTop() + heightDrawn, this.selectedLineColor, this.textColor, false, true);
            }
            heightDrawn += this.getElementHeight(nextElement);
        }
        RenderUtils.endStencil();
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int heightDrawn = 0;
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        RenderUtils.beginStencil();
        this.drawStencil(this.getContentLeft(), this.getContentTop(), this.getContentRight(), this.getContentBottom(), 1);
        GlStateManager.func_179109_b((float)(-this.scrollHoriz), (float)0.0f, (float)0.0f);
        int e = this.getElementCount();
        for (int nextElement = this._firstIndexDisplayed; nextElement < e && heightDrawn <= this.getContentHeight(); ++nextElement) {
            if (!this.shouldBeDisplayed(this.getElement(nextElement))) continue;
            if (this._selectedIndex == nextElement) {
                this.DrawElement(nextElement, this.getContentLeft(), this.getContentTop() + heightDrawn, this.selectedLineColor, this.selectedTextColor, true, false);
            } else {
                this.DrawElement(nextElement, this.getContentLeft(), this.getContentTop() + heightDrawn, this.selectedLineColor, this.textColor, false, false);
            }
            GL11.glDisable((int)2960);
            if (this.getContentTop() + heightDrawn <= mouseY && this.getContentTop() + heightDrawn + this.getElementHeight(nextElement) >= mouseY && mouseX >= this.getContentLeft() && mouseX <= this.getContentLeft() + this.getElementWidth(nextElement)) {
                this.drawElementTooltip(nextElement, mouseX, mouseY);
            }
            GL11.glEnable((int)2960);
            heightDrawn += this.getElementHeight(nextElement);
        }
        RenderUtils.endStencil();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        int heightChecked = 0;
        for (int i = this._firstIndexDisplayed; i < this.getElementCount() && heightChecked <= this.getContentHeight(); ++i) {
            if (!this.shouldBeDisplayed(this.getElement(i))) continue;
            int elementHeight = this.getElementHeight(i);
            if (this.getContentTop() + heightChecked <= mouseY && this.getContentTop() + heightChecked + elementHeight >= mouseY) {
                this.setSelectedIndex(i);
                this.onElementClicked(i, mouseX - this.getContentLeft(), mouseY - (this.getContentTop() + heightChecked));
                break;
            }
            heightChecked += elementHeight;
        }
        return true;
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (MOStringHelper.isControlKeyDown()) {
            if (movement > 0) {
                this.scrollLeft();
            } else if (movement < 0) {
                this.scrollRight();
            }
        } else if (movement > 0) {
            this.scrollUp();
        } else if (movement < 0) {
            this.scrollDown();
        }
        return true;
    }

    public void scrollDown() {
        int heightDisplayed = 0;
        int elementsDisplayed = 0;
        for (int i = this._firstIndexDisplayed; i < this.getElementCount() && heightDisplayed + this.getElementHeight(i) <= this.sizeY; ++i) {
            heightDisplayed += this.getElementHeight(i);
            ++elementsDisplayed;
        }
        if (this._firstIndexDisplayed + elementsDisplayed < this.getElementCount()) {
            ++this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollUp() {
        if (this._firstIndexDisplayed > 0) {
            --this._firstIndexDisplayed;
        }
        this.onScrollV(this._firstIndexDisplayed);
    }

    public void scrollLeft() {
        this.scrollHoriz = Math.max(this.scrollHoriz - 15, 0);
        this.onScrollH(this.scrollHoriz);
    }

    public void scrollRight() {
        this.scrollHoriz = Math.min(this.scrollHoriz + 15, this.getLastScrollPositionH());
        this.onScrollH(this.scrollHoriz);
    }

    public int getLastScrollPosition() {
        int position = this.getElementCount() - 1;
        for (int heightUsed = this.getElementHeight(position); position > 0 && heightUsed < this.sizeY; heightUsed += this.getElementHeight(--position)) {
        }
        return position + 1;
    }

    public int getLastScrollPositionH() {
        return Math.max(this.getInternalWidth() - this.getContentWidth(), 0);
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.getElementCount() && index != this._selectedIndex) {
            this._selectedIndex = index;
            this.onSelectionChanged(this._selectedIndex, this.getSelectedElement());
        }
    }

    public int getIndexOf(Object value) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (!this.getElement(i).getValue().equals(value)) continue;
            return i;
        }
        return -1;
    }

    public IMOListBoxElement getSelectedElement() {
        if (this._selectedIndex < this.getElementCount()) {
            return this.getElement(MathHelper.func_76125_a((int)this._selectedIndex, (int)0, (int)this._elements.size()));
        }
        return null;
    }

    public void scrollToV(int index) {
        if (index >= 0 && index < this.getElementCount()) {
            this._firstIndexDisplayed = index;
        }
    }

    public void scrollToH(int index) {
        if (index >= 0 && index <= this.getLastScrollPositionH()) {
            this.scrollHoriz = index;
        }
    }

    public void DrawElement(int i, int x, int y, int selectedLineColor, int selectedTextColor, boolean selected, boolean BG) {
        this.getElement(i).draw(this, x, y, selectedLineColor, selectedTextColor, selected, BG);
    }

    public void drawElementTooltip(int index, int mouseX, int mouseY) {
        this.getElement(index).drawToolTop(this, mouseX, mouseY);
    }

    public int getElementHeight(int id) {
        return this._elements.get(id).getHeight();
    }

    public int getElementWidth(int id) {
        return this._elements.get(id).getWidth();
    }

    protected boolean shouldBeDisplayed(IMOListBoxElement element) {
        return true;
    }

    public IMOListBoxElement getElement(int index) {
        return this._elements.get(index);
    }

    public int getElementCount() {
        return this._elements.size();
    }

    protected void onElementClicked(int index, int mousX, int mouseY) {
    }

    protected void onScrollV(int newStartIndex) {
    }

    protected void onScrollH(int newStartIndex) {
    }

    protected void onSelectionChanged(int newIndex, IMOListBoxElement imoListBoxElement) {
        this.listHandler.ListSelectionChange(this.getName(), newIndex);
    }
}

